/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingElementNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

public class ItemCheckingFeed
extends ItemFeed {
    private ItemType requiredType;
    private RoleDiagnostic role;
    private Configuration config;

    public ItemCheckingFeed(Expression checker, Feed result, XPathContext context) {
        super(checker, result, context);
        this.requiredType = ((ItemChecker)checker).getRequiredType();
        this.role = ((ItemChecker)checker).getRoleLocator();
        this.config = context.getConfiguration();
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            this.checkItemType(node);
            return this.getResult().startSelectedParentNode(node, locationId);
        }
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            this.getResult().endSelectedParentNode(locationId);
        }
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        if (!this.hasFailed()) {
            this.checkItemType(item);
            this.getResult().processItem(item);
        }
    }

    private void checkItemType(Item item) throws XPathException {
        TypeHierarchy th = this.config.getTypeHierarchy();
        if (!this.hasFailed() && !this.requiredType.matches(item, th)) {
            String message = this.role.composeErrorMessage(this.requiredType, item, th);
            String errorCode = this.role.getErrorCode();
            if ("XPDY0050".equals(errorCode)) {
                XPathException te = new XPathException(message, errorCode, this.getExpression().getLocation());
                te.setIsTypeError(false);
                this.dynamicError(te);
            } else {
                this.typeError(message, errorCode);
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            this.getResult().close();
        }
    }

    private void typeError(String message, String errorCode) throws XPathException {
        XPathException e = new XPathException(message, errorCode, this.getExpression().getLocation());
        e.setIsTypeError(true);
        this.dynamicError(e);
    }

    @Override
    public SequenceReceiver getReceiver() {
        Receiver next = this.getResult().getReceiver();
        final FleetingDocumentNode root = new FleetingDocumentNode(-1L);
        root.setConfiguration(this.config);
        return new ProxyReceiver(next){
            int level;
            {
                super(nextReceiver);
                this.level = 0;
            }

            @Override
            public void startDocument(int properties) throws XPathException {
                if (this.level++ == 0) {
                    ItemCheckingFeed.this.checkItemType(new FleetingDocumentNode(-1L));
                }
                super.startDocument(properties);
            }

            @Override
            public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
                if (this.level++ == 0) {
                    FleetingElementNode node = new FleetingElementNode(elemName, typeCode);
                    node.setParent(root);
                    ItemCheckingFeed.this.checkItemType(node);
                }
                super.startElement(elemName, typeCode, location, properties);
            }

            @Override
            public void endElement() throws XPathException {
                --this.level;
                super.endElement();
            }

            @Override
            public void endDocument() throws XPathException {
                --this.level;
                super.endDocument();
            }
        };
    }
}

