/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.PendingUpdateAction;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SimpleType;

public class ReplaceAttributeAction
extends PendingUpdateAction {
    private NodeInfo element;
    private NodeInfo oldAttribute;
    AttributeCollection newAttributes;

    public ReplaceAttributeAction(NodeInfo element, NodeInfo oldAttribute, AttributeCollection newAttributes) {
        this.element = element;
        this.oldAttribute = oldAttribute;
        this.newAttributes = newAttributes;
    }

    @Override
    public void apply(XPathContext context, Set affectedRootSet) throws XPathException {
        if (!(this.element instanceof MutableNodeInfo)) {
            throw new XPathException("Attempting to update a non-updateable element");
        }
        affectedRootSet.add(this.element.getRoot());
        ((MutableNodeInfo)this.element).removeAttribute(this.oldAttribute);
        int len = this.newAttributes.getLength();
        for (int i = 0; i < len; ++i) {
            NodeName name = this.newAttributes.getNodeName(i);
            SimpleType typeCode = this.newAttributes.getTypeAnnotation(i);
            String value = this.newAttributes.getValue(i);
            int properties = this.newAttributes.getProperties(i);
            if (this.element.getAttributeValue(name.getURI(), name.getLocalPart()) != null) {
                throw new XPathException("Attempting to add an attribute that already exists");
            }
            ((MutableNodeInfo)this.element).addAttribute(name, typeCode, value, properties);
        }
        ((MutableNodeInfo)this.element).removeTypeAnnotation();
    }

    @Override
    public NodeInfo getTargetNode() {
        return this.element;
    }

    public NodeInfo getOldAttribute() {
        return this.oldAttribute;
    }

    public AttributeCollection getNewAttributes() {
        return this.newAttributes;
    }

    @Override
    public int getApplyPhase() {
        return 3;
    }
}

