/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SimpleComponentReference;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.UserSchemaComponent;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashSet;

public abstract class Particle
extends SimpleComponentReference
implements UserSchemaComponent {
    private int maxOccurs = 1;
    private int minOccurs = 1;
    private boolean vulnerable = false;
    public static final int UNBOUNDED = -1;

    public final int getMaxOccurs() {
        return this.maxOccurs;
    }

    public final int getMinOccurs() {
        return this.minOccurs;
    }

    public final void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public final void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public abstract Term getTerm() throws MissingComponentException;

    public final void setVulnerable(boolean vulnerable) {
        this.vulnerable = vulnerable;
    }

    public void markVulnerableSubParticles() throws MissingComponentException {
    }

    public final boolean isVulnerable() {
        return this.vulnerable;
    }

    public static int computeParticleCardinality(int minOccurs, int maxOccurs) {
        if (maxOccurs == -1 || maxOccurs > 1) {
            if (minOccurs == 1) {
                return 49152;
            }
            return 57344;
        }
        if (maxOccurs == 1) {
            if (minOccurs == 0) {
                return 24576;
            }
            return 16384;
        }
        return 0;
    }

    public abstract boolean containsElementWildcard() throws MissingComponentException;

    public abstract void gatherAllPermittedElements(IntHashSet var1, boolean var2) throws SchemaException;

    public abstract int getElementParticleCardinality(int var1) throws MissingComponentException;

    public abstract boolean isEmptiable() throws MissingComponentException;

    public abstract SchemaType getElementParticleType(int var1) throws MissingComponentException;

    @Override
    public abstract boolean fixup(SchemaCompiler var1) throws SchemaException;

    @Override
    public abstract boolean validate(SchemaCompiler var1) throws SchemaException;

    public abstract void compile(SchemaCompiler var1) throws SchemaException;

    public abstract boolean isPointless(ModelGroup var1) throws MissingComponentException;

    public abstract void serializeParticle(SchemaModelSerializer var1) throws XPathException, MissingComponentException;

    @Override
    public FunctionItem getComponentAsFunction() {
        Particle thisParticle = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Particle");
                }
                case "implementation": {
                    return new ObjectValue<Particle>(thisParticle);
                }
                case "min occurs": {
                    return new Int64Value(this.getMinOccurs(), BuiltInAtomicType.NON_NEGATIVE_INTEGER, false);
                }
                case "max occurs": {
                    if (this.getMaxOccurs() < 0) {
                        return StringValue.bmp("unbounded");
                    }
                    return new Int64Value(this.getMaxOccurs(), BuiltInAtomicType.NON_NEGATIVE_INTEGER, false);
                }
                case "term": {
                    return ((SchemaComponent)((Object)this.getTerm())).getComponentAsFunction();
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

