/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.ee.parallel.PushToPull;
import com.saxonica.ee.parallel.Pusher;
import com.saxonica.ee.stream.AccumulatorRegistryEE;
import com.saxonica.ee.stream.ContentDetector;
import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.watch.StreamWatch;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.SourceDocument;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.value.AtomicValue;

public class StreamInstr
extends SourceDocument
implements Pusher {
    private Inversion action;

    public StreamInstr(Expression hrefExp, Expression body, ParseOptions options) {
        super(hrefExp, body, options);
    }

    @Override
    public void setSpaceStrippingRule(SpaceStrippingRule rule) {
        this.parseOptions = this.parseOptions.withSpaceStrippingRule(rule);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        ContextItemStaticInfo newType = this.getConfiguration().makeContextItemStaticInfo(NodeKindTest.DOCUMENT, false);
        newType.setContextPostureStriding();
        this.hrefOp.optimize(visitor, contextItemType);
        boolean previouslyStreaming = visitor.isOptimizeForStreaming();
        visitor.setOptimizeForStreaming(true);
        this.bodyOp.optimize(visitor, newType);
        visitor.setOptimizeForStreaming(previouslyStreaming);
        return this;
    }

    public Expression prepareForStreaming(PackageData pack) throws XPathException {
        Configuration config = pack.getConfiguration();
        int localLicense = pack.getLocalLicenseId();
        ArrayList<String> reasons = new ArrayList<String>();
        Expression doc = this.checkStreamability(reasons, config.isStreamabilityEnabled(), false);
        if (doc != null) {
            return doc;
        }
        this.action = Inversion.invertExpression(this.getBody(), false);
        return this;
    }

    @Override
    public void prepareForStreaming() throws XPathException {
        if (this.action == null) {
            this.prepareForStreaming(this.getPackageData());
        }
    }

    public Expression checkStreamability(List<String> reasons, boolean enabled, boolean strict) throws XPathException {
        boolean streamable;
        Configuration config = this.getConfiguration();
        if (!enabled) {
            reasons.add("Streaming is disabled for this Saxon Configuration");
            streamable = false;
        } else {
            ContextItemStaticInfoEE contextInfo = new ContextItemStaticInfoEE(AnyItemType.getInstance(), true, Posture.STRIDING);
            contextInfo.setStrictStreamabilityRules(strict);
            PostureAndSweep s = Streamability.getStreamability(this.getBody(), contextInfo, reasons);
            boolean bl = streamable = s.getPosture() == Posture.GROUNDED;
            if (!streamable && reasons.isEmpty() && Streamability.isIncrementalPosture(s.getPosture())) {
                reasons.add("The instruction returns nodes from the streamed input document.");
            }
        }
        if (!streamable) {
            boolean fallback = config.getBooleanProperty(Feature.STREAMING_FALLBACK);
            if (fallback) {
                reasons.add("Falling back to non-streaming implementation");
            }
            StringBuilder message = new StringBuilder("The body of the xsl:source-document instruction is not streamable");
            for (String r : reasons) {
                message.append("\n  *  ").append(r);
            }
            XmlProcessingIncident err = new XmlProcessingIncident(message.toString(), "XTSE3430", this.getLocation()).asWarning();
            err.setStaticError(true);
            if (fallback) {
                config.makeErrorReporter().report(err);
                return new SourceDocument(this.getHref(), this.getBody(), this.parseOptions);
            }
            throw XPathException.fromXmlProcessingError(err);
        }
        return null;
    }

    @Override
    public boolean mayCreateNewNodes() {
        return !this.getBody().hasSpecialProperty(0x800000);
    }

    @Override
    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.getHref().getDependencies();
        return dependencies |= this.getBody().getDependencies() & 0xFFFFFFE1;
    }

    @Override
    protected int computeSpecialProperties() {
        Expression body = this.getBody();
        if (body.hasSpecialProperty(0x400000)) {
            return 655360;
        }
        return super.computeSpecialProperties();
    }

    public Inversion getAction() {
        return this.action;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        StreamInstr exp = new StreamInstr(this.getHref().copy(rebindings), this.getBody().copy(rebindings), this.parseOptions);
        exp.setRetainedStaticContext(this.getRetainedStaticContext());
        ExpressionTool.copyLocationInfo(this, exp);
        if (this.action != null) {
            try {
                exp.prepareForStreaming(this.getPackageData());
            }
            catch (XPathException e) {
                throw new AssertionError((Object)"Failure while preparing copy of xsl:stream instruction for streaming");
            }
        }
        return exp;
    }

    @Override
    public void push(Outputter output, XPathContext context) throws XPathException {
        PackageData pd = this.getPackageData();
        if (pd instanceof StylesheetPackage && ((StylesheetPackage)pd).isFallbackToNonStreaming()) {
            super.push(output, context);
        } else {
            Controller controller = context.getController();
            XPathContextMajor c2 = context.newContext();
            c2.setCurrentTemplateRule(null);
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            WatchManager wm = new WatchManager(pipe);
            wm.setXPathContext(context);
            wm.setOutputter(output);
            AccumulatorRegistryEE am = (AccumulatorRegistryEE)this.getRetainedStaticContext().getPackageData().getAccumulatorRegistry();
            if (am != null && this.accumulators != null) {
                AccumulatorRegistryEE.registerSelectedAccumulators(wm, this.accumulators);
            }
            Receiver stream = new ContentDetector(wm);
            if (this.getPackageData() instanceof StylesheetPackage && ((StylesheetPackage)this.getPackageData()).isStripsTypeAnnotations()) {
                stream = this.getConfiguration().getAnnotationStripper(stream);
            }
            if (this.action == null) {
                this.prepareForStreaming(this.getPackageData());
            }
            wm.addWatch(new StreamWatch(this.action, wm, c2), true);
            AtomicValue hrefVal = (AtomicValue)this.getHref().evaluateItem(context);
            String href = hrefVal.getStringValue();
            boolean verbose = controller.getConfiguration().isTiming();
            if (verbose) {
                try {
                    controller.getConfiguration().getLogger().info("Streaming " + ResolveURI.makeAbsolute(href, this.getStaticBaseURIString()));
                }
                catch (URISyntaxException e) {
                    controller.getConfiguration().getLogger().info("Streaming " + href);
                }
            }
            try {
                DocumentFn.sendDoc(href, this.getStaticBaseURIString(), this.getPackageData(), context, this.getLocation(), stream, this.parseOptions);
            }
            catch (QuitParsingException q) {
                q.maybeSetLocation(this.getLocation());
                q.maybeSetContext(context);
                if (verbose) {
                    controller.getConfiguration().getLogger().info("Streaming " + href + " : early exit ");
                }
                throw q;
            }
        }
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return new PushToPull(this.makeElaborator().elaborateForPush(), context).getIterator();
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        try {
            super.process(output, context);
        }
        catch (QuitParsingException quitParsingException) {
            // empty catch block
        }
    }

    @Override
    public String getExportTag() {
        return "stream";
    }

    @Override
    public Elaborator getElaborator() {
        return new StreamInstrElaborator();
    }

    public static class StreamInstrElaborator
    extends PushElaborator {
        @Override
        public PushEvaluator elaborateForPush() {
            StreamInstr expr = (StreamInstr)this.getExpression();
            return (output, context) -> {
                try {
                    expr.push(output, context);
                }
                catch (QuitParsingException q) {
                    if (q.isNotifiedByConsumer()) {
                        throw q;
                    }
                }
                catch (XPathException e) {
                    throw e.maybeWithLocation(expr.getLocation()).maybeWithErrorCode("FODC0002");
                }
                return null;
            };
        }

        @Override
        public PullEvaluator elaborateForPull() {
            PushEvaluator pusher = this.elaborateForPush();
            return context -> new PushToPull(pusher, context).getIterator();
        }
    }
}

