/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.TryCatch;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class TryCatchAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new TryCatchFeed(this.getExpression(), out, context);
    }

    public static class TryCatchFeed
    extends ItemFeed {
        private final ItemFeed originalResult;
        private boolean done = false;
        private boolean opened = false;

        TryCatchFeed(Expression exp, ItemFeed out, XPathContext context) {
            super(new ComplexContentOutputter(new SequenceCollector(out.getPipelineConfiguration())), context, true);
            this.setExpression(exp);
            this.originalResult = out;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            this.originalResult.open(terminator);
            this.getNextOutputter().open();
            this.opened = true;
        }

        @Override
        public void append(Item item) throws XPathException {
            this.getNextOutputter().append(item);
        }

        @Override
        public void close() throws XPathException {
            ComplexContentOutputter out = (ComplexContentOutputter)this.getNextOutputter();
            SequenceCollector collector = (SequenceCollector)out.getReceiver();
            collector.close();
            try {
                for (Item i : collector.getList()) {
                    this.originalResult.append(i);
                }
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
            this.originalResult.close();
        }

        @Override
        public void dynamicError(XPathException err) throws XPathException {
            if (err.isGlobalError()) {
                err.setIsGlobalError(false);
            } else {
                if (this.done) {
                    return;
                }
                if (!this.opened) {
                    this.open(new Terminator());
                }
                this.done = true;
                StructuredQName code = err.getErrorCodeQName();
                for (TryCatch.CatchClause clause : ((TryCatch)this.getExpression()).getCatchClauses()) {
                    if (code == null) {
                        code = new StructuredQName("saxon", NamespaceUri.SAXON, "XXXX9999");
                    }
                    if (!clause.nameTest.matches(code)) continue;
                    Expression caught = clause.catchOp.getChildExpression();
                    XPathContextMajor c2 = this.getContext().newContext();
                    c2.setCurrentException(err);
                    SequenceIterator iter = caught.iterate(c2);
                    TryCatchFeed.processItems(iter, this.originalResult);
                    this.originalResult.close();
                    return;
                }
            }
            err.setHasBeenReported(false);
            throw err;
        }
    }
}

