/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.parallel.PushToPull;
import com.saxonica.ee.stream.AccumulatorRegistryEE;
import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.watch.StreamWatch;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.sort.MergeInstr;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SnapshotFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;

public class MergeInstrAdjunct
extends StreamingAdjunct {
    public static void checkStreamability(MergeInstr.MergeSource mergeSource, Configuration config) throws XPathException {
        String streamabilityOption = config.getConfigurationProperty(Feature.STREAMABILITY);
        boolean actuallyStreamable = true;
        ArrayList<String> reasons = new ArrayList<String>();
        if (streamabilityOption.equals("off")) {
            reasons.add("Streaming is disabled at the Saxon Configuration level");
            actuallyStreamable = false;
        } else {
            Iterator snapshot;
            ContextItemStaticInfoEE info = new ContextItemStaticInfoEE(NodeKindTest.DOCUMENT, false, Posture.STRIDING);
            Expression rowSelect = mergeSource.getRowSelect();
            if (rowSelect.isCallOn(SnapshotFn.class)) {
                snapshot = rowSelect;
                rowSelect = ((SystemFunctionCall)rowSelect).getArg(0);
            } else {
                snapshot = SystemFunction.makeCall("snapshot", rowSelect.getRetainedStaticContext(), mergeSource.getRowSelect());
                mergeSource.setRowSelect((Expression)((Object)snapshot));
            }
            PostureAndSweep ps = Streamability.getStreamability(rowSelect, info, reasons);
            if (ps.getPosture() != Posture.STRIDING) {
                actuallyStreamable = false;
                reasons.add("The select expression for the merge source is not striding");
            } else {
                Streamability.getStreamability(snapshot, info, reasons);
                mergeSource.invertedAction = Inversion.invertExpression(snapshot, false);
            }
        }
        if (!actuallyStreamable) {
            StringBuilder buffer;
            boolean fallback = config.getBooleanProperty(Feature.STREAMING_FALLBACK);
            if (fallback) {
                buffer = new StringBuilder(120);
                buffer.append("Executing without streaming. ");
                for (String s : reasons) {
                    buffer.append(s + ". ");
                }
                config.makeErrorReporter().report(new XmlProcessingIncident(buffer.toString(), "SXWN9024").asWarning());
                mergeSource.streamable = false;
            } else {
                buffer = new StringBuilder(120);
                buffer.append("Streaming requested for xsl:merge, but the construct is not streamable. ");
                for (String s : reasons) {
                    buffer.append(s + ". ");
                }
                XPathException err = new XPathException(buffer.toString(), "XTSE3430");
                err.setIsStaticError(true);
                throw err;
            }
        }
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        MergeInstr instr = (MergeInstr)this.getExpression();
        for (MergeInstr.MergeSource ms : instr.getMergeSources()) {
            if (ms.getForEachItem() != null && !Streamability.getStreamability(ms.getForEachItem(), contextInfo, reasons).equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) {
                reasons.add("The for-each-item expression, if present, must be grounded and motionless");
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            if (ms.getForEachSource() != null && !Streamability.getStreamability(ms.getForEachSource(), contextInfo, reasons).equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) {
                reasons.add("The for-each-source expression, if present, must be grounded and motionless");
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            if (ms.getForEachItem() != null || ms.getForEachSource() != null || Streamability.getStreamability(ms.getRowSelect(), contextInfo, reasons).equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) continue;
            reasons.add("If neither of the attributes for-each-item or for-each-source is present, the select expression must be grounded and motionless");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
    }

    public static List<ContextMappingIterator> makeSourceIterators(MergeInstr.MergeSource ms, PackageData pd, XPathContext c1) throws XPathException {
        Item uri;
        ArrayList<ContextMappingIterator> result = new ArrayList<ContextMappingIterator>();
        SequenceIterator uriIter = ms.getForEachSource().iterate(c1);
        while ((uri = uriIter.next()) != null) {
            ParseOptions options = c1.getConfiguration().getParseOptions().withSchemaValidationMode(ms.validation).withTopLevelType(ms.schemaType).withApplicableAccumulators(ms.accumulators);
            String href = uri.getStringValue();
            MergePusher pusher = new MergePusher(ms, pd, href, options);
            SequenceIterator iter = MergeInstrAdjunct.pushToPull(pusher, c1);
            XPathContextMinor c2 = c1.newMinorContext();
            c2.trackFocus(iter);
            MergeInstr.MergeKeyMappingFunction addMergeKeys = new MergeInstr.MergeKeyMappingFunction(c2, ms);
            ContextMappingIterator iter3 = new ContextMappingIterator(addMergeKeys::map, c2);
            result.add(iter3);
        }
        return result;
    }

    private static SequenceIterator pushToPull(MergePusher pusher, XPathContext c1) {
        return new PushToPull(pusher, c1).getIterator();
    }

    public static class MergePusher
    implements PushEvaluator {
        private final MergeInstr.MergeSource ms;
        private final PackageData pd;
        private final String href;
        private final ParseOptions options;

        public MergePusher(MergeInstr.MergeSource ms, PackageData pd, String href, ParseOptions options) {
            this.ms = ms;
            this.pd = pd;
            this.href = href;
            this.options = options;
        }

        @Override
        public TailCall processLeavingTail(Outputter output, XPathContext context) throws XPathException {
            Controller controller = context.getController();
            XPathContextMajor c2 = context.newContext();
            c2.setCurrentTemplateRule(null);
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setXPathContext(context);
            WatchManager wm = new WatchManager(pipe);
            wm.setXPathContext(context);
            wm.setOutputter(output);
            AccumulatorRegistryEE am = (AccumulatorRegistryEE)this.pd.getAccumulatorRegistry();
            if (am != null && this.ms.accumulators != null) {
                AccumulatorRegistryEE.registerSelectedAccumulators(wm, this.ms.accumulators);
            }
            Receiver out = wm;
            if (this.pd instanceof StylesheetPackage && ((StylesheetPackage)this.pd).isStripsTypeAnnotations()) {
                out = this.pd.getConfiguration().getAnnotationStripper(out);
            }
            wm.addWatch(new StreamWatch((Inversion)this.ms.invertedAction, wm, c2), true);
            DocumentFn.sendDoc(this.href, this.ms.baseURI, this.pd, context, this.ms.location, out, this.options);
            return null;
        }
    }
}

