/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PushToReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.Invalidity;
import net.sf.saxon.lib.InvalidityReportGenerator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.push.Document;
import net.sf.saxon.s9api.push.Element;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DateTimeValue;

public class InvalidityReportGeneratorEE
extends InvalidityReportGenerator {
    private Destination destination = null;
    private final int warningCount = 0;
    private int errorCount = 0;
    private String xsdversion = "1.0";
    private String systemId = null;
    private String schemaName = null;
    private Builder builder;
    private boolean closed = false;
    private Document doc;
    private Element report;
    boolean started = false;

    public InvalidityReportGeneratorEE(Configuration config) {
        super(config);
    }

    public InvalidityReportGeneratorEE(Configuration config, Destination destination) throws SaxonApiException {
        super(config);
        this.destination = destination;
        Receiver r = destination.getReceiver(config.makePipelineConfiguration(), config.obtainDefaultSerializationProperties());
        this.doc = new PushToReceiver(r).document(true);
    }

    public InvalidityReportGeneratorEE(Configuration config, Receiver receiver) throws XPathException {
        super(config);
        if (receiver instanceof Builder) {
            this.builder = (Builder)receiver;
        }
        NamespaceReducer r = new NamespaceReducer(receiver);
        try {
            this.doc = new PushToReceiver(r).document(true);
        }
        catch (SaxonApiException e) {
            throw XPathException.makeXPathException(e);
        }
    }

    public void setReceiver(Receiver receiver) {
        if (receiver instanceof Builder) {
            this.builder = (Builder)receiver;
        }
        NamespaceReducer r = new NamespaceReducer(receiver);
        try {
            this.doc = new PushToReceiver(r).document(true);
        }
        catch (SaxonApiException e) {
            throw new UncheckedXPathException(XPathException.makeXPathException(e));
        }
    }

    public void setDestination(Destination destination) throws SaxonApiException {
        this.destination = destination;
        Receiver r = destination.getReceiver(this.getConfiguration().makePipelineConfiguration(), this.getConfiguration().obtainDefaultSerializationProperties());
        this.doc = new PushToReceiver(r).document(true);
    }

    @Override
    public void setSystemId(String id) {
        this.systemId = id;
    }

    @Override
    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return 0;
    }

    @Override
    public void setXsdVersion(String version) {
        this.xsdversion = version;
    }

    @Override
    public void reportInvalidity(Invalidity failure) throws XPathException {
        if (this.closed) {
            return;
        }
        ++this.errorCount;
        try {
            Element error = this.report.element("error").attribute("line", this.ifPositive(failure.getLineNumber())).attribute("column", this.ifPositive(failure.getColumnNumber())).attribute("path", failure.getPath().toString()).attribute("system-id", failure.getSystemId() != null && !failure.getSystemId().equals(this.systemId) ? failure.getSystemId() : null).attribute("xsd-part", this.ifPositive(failure.getSchemaPart())).attribute("constraint", failure.getConstraintReference()).attribute("context-path", failure.getContextPath() == null ? null : failure.getContextPath().toString()).text(failure.getMessage());
            if (failure instanceof ValidationFailure) {
                List<NodeInfo> offenders = ((ValidationFailure)failure).getOffendingNodes();
                for (NodeInfo node : offenders) {
                    error.text("\n          ");
                    error.element("contributing-node").attribute("type", Type.displayTypeName(node)).attribute("content", node.getNodeKind() == 3 && node.getUnicodeStringValue().estimatedLength() < 200L ? node.getStringValue() : null).attribute("line", this.ifPositive(node.getLineNumber())).attribute("column", this.ifPositive(node.getColumnNumber())).attribute("path", Navigator.getPath(node)).attribute("system-id", node.getSystemId() != null && !node.getSystemId().equals(this.systemId) ? node.getSystemId() : null).close();
                }
            }
            error.close();
        }
        catch (SaxonApiException e) {
            throw new XPathException(e);
        }
    }

    private String ifPositive(int value) {
        return value < 0 ? null : "" + value;
    }

    public Destination getDestination() {
        return this.destination;
    }

    @Override
    public void startReporting(String systemId) throws XPathException {
        if (this.closed) {
            return;
        }
        this.systemId = systemId;
        if (systemId != null) {
            try {
                this.systemId = new URI(systemId).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (!this.started) {
            try {
                this.started = true;
                this.doc.setDefaultNamespace(REPORT_NS.toString());
                this.report = this.doc.element("validation-report");
                if (this.systemId != null) {
                    this.report.attribute("system-id", this.systemId);
                }
            }
            catch (SaxonApiException e) {
                throw new XPathException(e);
            }
        }
    }

    @Override
    public Sequence endReporting() throws XPathException {
        if (this.closed) {
            return null;
        }
        this.createMetaData();
        try {
            if (!this.started) {
                throw new IllegalStateException("Reporting not started");
            }
            this.report.close();
            this.doc.close();
            this.closed = true;
        }
        catch (SaxonApiException e) {
            throw new XPathException(e);
        }
        if (this.builder != null) {
            return this.builder.getCurrentRoot();
        }
        return super.endReporting();
    }

    @Override
    public void createMetaData() throws XPathException {
        try {
            Element metadata = this.report.element("meta-data");
            metadata.element("validator").attribute("name", Version.getProductName() + "-" + this.getConfiguration().getEditionCode()).attribute("version", Version.getProductVersion());
            metadata.element("results").attribute("errors", "" + this.errorCount).attribute("warnings", "0");
            metadata.element("schema").attribute("file", this.schemaName).attribute("xsd-version", this.xsdversion);
            metadata.element("run").attribute("at", DateTimeValue.getCurrentDateTime(null).getStringValue());
            metadata.close();
        }
        catch (SaxonApiException ex) {
            throw new XPathException(ex);
        }
    }
}

