/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanAttributeQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeSpans
extends SimpleSpans {
    private List<CandidateAttributeSpan> candidateList;
    private int currentDoc;
    private int currentPosition;
    private boolean isFinish;
    protected Logger logger = LoggerFactory.getLogger(AttributeSpans.class);

    public AttributeSpans(SpanAttributeQuery spanAttributeQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(spanAttributeQuery, context, acceptDocs, termContexts);
        this.hasSpanId = true;
        this.candidateList = new ArrayList<CandidateAttributeSpan>();
        this.hasMoreSpans = this.firstSpans.next();
        if (this.hasMoreSpans) {
            this.currentDoc = this.firstSpans.doc();
            this.currentPosition = this.firstSpans.start();
        }
    }

    @Override
    public boolean next() throws IOException {
        this.isStartEnumeration = false;
        this.matchPayload.clear();
        return this.advance();
    }

    private boolean advance() throws IOException {
        while (this.hasMoreSpans || !this.candidateList.isEmpty()) {
            if (!this.candidateList.isEmpty()) {
                CandidateAttributeSpan cs = this.candidateList.get(0);
                this.matchDocNumber = cs.getDoc();
                this.matchStartPosition = cs.getStart();
                this.matchEndPosition = cs.getEnd();
                this.setSpanId(cs.getSpanId());
                this.candidateList.remove(0);
                return true;
            }
            this.setCandidateList();
            this.currentDoc = this.firstSpans.doc();
            this.currentPosition = this.firstSpans.start();
        }
        return false;
    }

    private void setCandidateList() throws IOException {
        while (this.hasMoreSpans && this.firstSpans.doc() == this.currentDoc && this.firstSpans.start() == this.currentPosition) {
            this.candidateList.add(this.createCandidateSpan());
            this.hasMoreSpans = this.firstSpans.next();
        }
        Collections.sort(this.candidateList);
        Collections.reverse(this.candidateList);
    }

    private CandidateAttributeSpan createCandidateSpan() throws IOException {
        List payload = (List)this.firstSpans.getPayload();
        ByteBuffer payloadBuffer = ByteBuffer.wrap((byte[])payload.get(0));
        byte payloadTypeIdentifier = payloadBuffer.get(0);
        short spanId = payloadBuffer.getShort(1);
        int end = ((byte[])payload.get(0)).length >= 7 ? payloadBuffer.getInt(3) : this.firstSpans.start();
        return new CandidateAttributeSpan(this.firstSpans, payloadTypeIdentifier, spanId, end);
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public void setFinish(boolean isFinish) {
        this.isFinish = isFinish;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.candidateList.clear();
            return false;
        }
        this.setCandidateList();
        this.matchPayload.clear();
        this.isStartEnumeration = false;
        return this.advance();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost();
    }

    class CandidateAttributeSpan
    extends CandidateSpan
    implements Comparable<CandidateSpan> {
        public CandidateAttributeSpan(Spans span, byte payloadTypeIdenfitier, short spanId, int elementEnd) throws IOException {
            super(span);
            this.spanId = spanId;
            this.end = elementEnd;
            this.payloadTypeIdentifier = payloadTypeIdenfitier;
        }

        @Override
        public int compareTo(CandidateSpan o) {
            CandidateAttributeSpan cs = (CandidateAttributeSpan)o;
            if (this.spanId == cs.spanId) {
                return 0;
            }
            if (this.spanId > cs.spanId) {
                return 1;
            }
            return -1;
        }
    }

    public static enum PayloadTypeIdentifier {
        TERM_ATTRIBUTE(16),
        ELEMENT_ATTRIBUTE(17),
        RELATION_ATTRIBUTE(18);

        private int value;

        private PayloadTypeIdentifier(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

