/*
 * Decompiled with CFR 0.152.
 */
package lemming.test.lemma.toutanova;

import java.util.List;
import lemming.lemma.BackupLemmatizerTrainer;
import lemming.lemma.LemmaInstance;
import lemming.lemma.LemmaOptions;
import lemming.lemma.Lemmatizer;
import lemming.lemma.SimpleLemmatizerTrainer;
import lemming.lemma.toutanova.FirstOrderDecoder;
import lemming.lemma.toutanova.ToutanovaTrainer;
import lemming.test.lemma.toutanova.SimpleTrainerTest;
import marmot.morph.io.SentenceReader;
import org.junit.Test;

public class ToutanovaTrainerTest
extends SimpleTrainerTest {
    @Test
    public void isSerializable() {
        this.testIfLemmatizerIsSerializable(new SimpleLemmatizerTrainer());
        this.testIfLemmatizerIsSerializable(new ToutanovaTrainer());
    }

    @Test
    public void copyTest() {
        ToutanovaTrainer trainer = new ToutanovaTrainer();
        String indexes = "form-index=4,lemma-index=5,";
        String trainfile = indexes + this.getResourceFile("trn_sml.tsv");
        String testfile = indexes + this.getResourceFile("dev_sml.tsv");
        List<LemmaInstance> training_instances = this.getCopyInstances(LemmaInstance.getInstances(new SentenceReader(trainfile)));
        Lemmatizer lemmatizer = trainer.train(training_instances, null);
        List<LemmaInstance> instances = LemmaInstance.getInstances(new SentenceReader(testfile));
        this.assertAccuracy(lemmatizer, this.getCopyInstances(instances), 99.1935);
    }

    @Test
    public void moderateZeroOrderAlignerPosTest() {
        BackupLemmatizerTrainer trainer = new BackupLemmatizerTrainer();
        LemmaOptions options = trainer.getOptions();
        options.setOption("backup-lemmatizer-model-use-backup", false);
        options.setOption("backup-lemmatizer-backup-seed", 10L);
        this.runModerateTest(trainer, 1.0, 92.72);
    }

    @Test
    public void smallTest() {
        SimpleLemmatizerTrainer simple_trainer = new SimpleLemmatizerTrainer();
        simple_trainer.getOptions().setOption("handle-unseen", false);
        simple_trainer.getOptions().setOption("use-backup", false);
        simple_trainer.getOptions().setOption("use-pos", true);
        simple_trainer.getOptions().setOption("abstain-if-ambigious", true);
        ToutanovaTrainer trainer = new ToutanovaTrainer();
        trainer.getOptions().setOption("num-iterations", 10);
        trainer.getOptions().setOption("use-pos", false);
        trainer.getOptions().setOption("filter-alphabet", 1);
        trainer.getOptions().setOption("averaging", false);
        trainer.getOptions().setOption("decoder", FirstOrderDecoder.class);
        BackupLemmatizerTrainer btrainer = new BackupLemmatizerTrainer(simple_trainer, trainer);
        this.runSmallTest(btrainer, 1.0, 79.56);
    }

    @Test
    public void smallPosTest() {
        SimpleLemmatizerTrainer simple_trainer = new SimpleLemmatizerTrainer();
        simple_trainer.getOptions().setOption("handle-unseen", false);
        simple_trainer.getOptions().setOption("use-backup", false);
        simple_trainer.getOptions().setOption("use-pos", true);
        simple_trainer.getOptions().setOption("abstain-if-ambigious", true);
        ToutanovaTrainer trainer = new ToutanovaTrainer();
        trainer.getOptions().setOption("num-iterations", 10);
        trainer.getOptions().setOption("use-pos", true);
        trainer.getOptions().setOption("filter-alphabet", 1);
        trainer.getOptions().setOption("averaging", true);
        trainer.getOptions().setOption("decoder", FirstOrderDecoder.class);
        BackupLemmatizerTrainer btrainer = new BackupLemmatizerTrainer(simple_trainer, trainer);
        this.runSmallTest(btrainer, 1.0, 84.88);
    }
}

