/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.openlp;

import java.util.List;

public interface Aligner {
    public Result align(String var1, String var2);

    public static class Pair {
        public int a;
        public int b;

        public Pair(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public String toString() {
            return String.format("(%d, %d)", this.a, this.b);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Pair)) {
                return false;
            }
            Pair other_pair = (Pair)other;
            return this.a == other_pair.a && this.b == other_pair.b;
        }
    }

    public static class Result {
        public ResultType result_type;
        public List<Pair> pairs;

        public Result(ResultType result_type) {
            this(result_type, null);
        }

        public Result(ResultType result_type, List<Pair> pairs) {
            this.result_type = result_type;
            this.pairs = pairs;
        }

        public String toString() {
            return String.format("(%s, %s)", new Object[]{this.result_type, this.pairs});
        }
    }

    public static enum ResultType {
        Timeout,
        NoAlignmentFound,
        Standard;

    }
}

