/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class ShallowCopyEventFeed
extends ItemFeed {
    private final Mode mode;

    public ShallowCopyEventFeed(Mode mode, ItemFeed parentExpressionFeed, XPathContext context) {
        super(null, parentExpressionFeed, context);
        this.mode = mode;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        XPathContext context = this.getContext();
        Outputter receiver = this.getNextOutputter();
        NodeInfo node = (NodeInfo)context.getContextItem();
        if (node.getNodeKind() == 9) {
            receiver.startDocument(0);
        } else {
            XPathContextMajor c2 = context.newContext();
            boolean schemaAware = context.getController().getExecutable().isSchemaAware();
            Enum schemaType = schemaAware ? AnyType.getInstance() : Untyped.getInstance();
            receiver.startElement(NameOfNode.makeName(node), (SchemaType)((Object)schemaType), Loc.NONE, 0);
            for (NamespaceBinding ns : node.getAllNamespaces()) {
                receiver.namespace(ns.getPrefix(), ns.getNamespaceUri(), 0);
            }
            AxisIterator attributes = node.iterateAxis(2);
            if (attributes != EmptyIterator.ofNodes()) {
                c2.trackFocus(attributes);
                this.mode.applyTemplates(context.getLocalParameters(), context.getTunnelParameters(), null, receiver, c2, Loc.NONE);
            }
        }
    }

    @Override
    public void append(Item item) throws XPathException {
        this.getNextOutputter().append(item);
    }

    @Override
    public void close() throws XPathException {
        XPathContext context = this.getContext();
        NodeInfo node = (NodeInfo)context.getContextItem();
        if (node.getNodeKind() == 9) {
            this.getNextOutputter().endDocument();
        } else {
            this.getNextOutputter().endElement();
        }
        super.close();
    }
}

