/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.util.Arrays;
import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public class OpFn
extends SystemFunction {
    private static final HashSet<String> allowedOperators = new HashSet();

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String op = arguments[0].head().getStringValue();
        String collation = this.getRetainedStaticContext().getDefaultCollationName();
        String cacheKey = "fn:op~" + collation;
        FunctionItem fn = (FunctionItem)context.getController().getUserData(cacheKey, op);
        if (fn == null) {
            OpFn.validateOperator(op);
            String xpath = "function($x, $y) {$x " + op + " $y}";
            XPathEvaluator eval = new XPathEvaluator(context.getConfiguration());
            IndependentContext env = new IndependentContext(context.getConfiguration());
            env.setDefaultCollationName(collation);
            env.setXPathLanguageLevel(40);
            eval.setStaticContext(env);
            XPathExpression cexp = eval.createExpression(xpath);
            XPathDynamicContext dc = cexp.createDynamicContext();
            fn = (FunctionItem)cexp.evaluateSingle(dc);
            context.getController().setUserData(cacheKey, op, fn);
        }
        return fn;
    }

    private static void validateOperator(String op) throws XPathException {
        if (!allowedOperators.contains(op)) {
            throw new XPathException("Unsupported operator '" + op + "'", "XPTY0004");
        }
    }

    static {
        String[] ops = new String[]{",", "and", "or", "+", "-", "*", "div", "idiv", "mod", "=", "<", "<=", ">", ">=", "!=", "eq", "lt", "le", "gt", "ge", "ne", "<<", ">>", "is", "||", "|", "union", "except", "intersect", "to", "otherwise"};
        allowedOperators.addAll(Arrays.asList(ops));
    }
}

