/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.BooleanValue;

public abstract class SequenceMatching
extends SystemFunction {
    protected BooleanValue startsWith(SequenceIterator iter0, SequenceIterator iter1, XPathContext context, FunctionItem comparator) throws XPathException {
        Item it1;
        Item it0;
        Sequence result;
        if (comparator == null) {
            Item it12;
            Item it02;
            boolean match;
            AtomicComparer comparer = GenericAtomicComparer.makeAtomicComparer(BuiltInAtomicType.ANY_ATOMIC, BuiltInAtomicType.ANY_ATOMIC, context.getConfiguration().getCollation(this.getRetainedStaticContext().getDefaultCollationName()), context);
            do {
                it02 = iter0.next();
                it12 = iter1.next();
                if (it12 == null) {
                    return BooleanValue.TRUE;
                }
                if (it02 != null) continue;
                return BooleanValue.FALSE;
            } while (match = DeepEqual.deepEqual(SingletonIterator.makeIterator(it02), SingletonIterator.makeIterator(it12), comparer, context, 0));
            return BooleanValue.FALSE;
        }
        do {
            it0 = iter0.next();
            it1 = iter1.next();
            if (it1 == null) {
                return BooleanValue.TRUE;
            }
            if (it0 != null) continue;
            return BooleanValue.FALSE;
        } while (((BooleanValue)(result = comparator.call(context, new Sequence[]{it0, it1})).head()).getBooleanValue());
        return BooleanValue.FALSE;
    }

    public static class ContainsSequence
    extends SequenceMatching {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            GroundedValue seq0 = arguments[0].materialize();
            GroundedValue seq1 = arguments[1].materialize();
            FunctionItem comparator = arguments.length == 3 ? (FunctionItem)arguments[2].head() : null;
            int len0 = seq0.getLength();
            int len2 = seq1.getLength();
            if (len2 == 0) {
                return BooleanValue.TRUE;
            }
            int latestStart = len0 - len2;
            for (int i = 0; i <= latestStart; ++i) {
                SequenceIterator iter1;
                SequenceIterator iter0 = TailIterator.make(seq0.iterate(), i + 1);
                BooleanValue result = this.startsWith(iter0, iter1 = seq1.iterate(), context, comparator);
                if (!result.getBooleanValue()) continue;
                return result;
            }
            return BooleanValue.FALSE;
        }
    }

    public static class EndsWithSequence
    extends SequenceMatching {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            SequenceIterator iter0 = Reverse.getReverseIterator(arguments[0].iterate());
            SequenceIterator iter1 = Reverse.getReverseIterator(arguments[1].iterate());
            FunctionItem comparator = arguments.length == 3 ? (FunctionItem)arguments[2].head() : null;
            return this.startsWith(iter0, iter1, context, comparator);
        }
    }

    public static class StartsWithSequence
    extends SequenceMatching {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            SequenceIterator iter0 = arguments[0].iterate();
            SequenceIterator iter1 = arguments[1].iterate();
            FunctionItem comparator = arguments.length == 3 ? (FunctionItem)arguments[2].head() : null;
            return this.startsWith(iter0, iter1, context, comparator);
        }
    }
}

