/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import com.saxonica.functions.qt4.Slice;
import com.saxonica.functions.qt4.UnparcelFn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Pingable;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.Parcel;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.ArraySort;
import net.sf.saxon.ma.arrays.ImmutableArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.zeno.ZenoSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntHashSet;

public class ArrayFunctionSet
extends BuiltInFunctionSet {
    private static final ArrayFunctionSet instance31 = new ArrayFunctionSet(31);
    private static final ArrayFunctionSet instance40 = new ArrayFunctionSet(40);

    private ArrayFunctionSet(int version) {
        this.init(version);
    }

    public static ArrayFunctionSet getInstance(int version) {
        return version >= 40 ? instance40 : instance31;
    }

    private void init(int version) {
        this.register("append", 2, e -> e.populate(ArrayAppend::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, AnyItemType.getInstance(), 0x800E000, null));
        this.register("build", 1, e -> e.populate(ArrayBuild::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, AnyItemType.getInstance(), 0x800E000, null));
        SpecificFunctionType buildFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_ITEM}, SequenceType.ANY_SEQUENCE);
        this.register("build", 2, e -> e.populate(ArrayBuild::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, AnyItemType.getInstance(), 0x800E000, null).arg(1, buildFunctionType, 0x1004000, null));
        SpecificFunctionType filterFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE}, SequenceType.SINGLE_BOOLEAN);
        this.register("filter", 2, e -> e.populate(ArrayFilter::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, filterFunctionType, 0x1004000, null));
        this.register("flatten", 1, e -> e.populate(ArrayFlatten::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 0x200E000, null));
        SpecificFunctionType foldFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE);
        this.register("fold-left", 3, e -> e.populate(ArrayFoldLeft::new, AnyItemType.getInstance(), 57344, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, AnyItemType.getInstance(), 0x800E000, null).arg(2, foldFunctionType, 0x1004000, null));
        this.register("fold-right", 3, e -> e.populate(ArrayFoldRight::new, AnyItemType.getInstance(), 57344, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, AnyItemType.getInstance(), 0x800E000, null).arg(2, foldFunctionType, 0x1004000, null));
        SpecificFunctionType forEachFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE);
        this.register("for-each", 2, e -> e.populate(ArrayForEach::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, forEachFunctionType, 0x1004000, null));
        this.register("for-each-pair", 3, e -> e.populate(ArrayForEachPair::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(2, foldFunctionType, 0x1004000, null));
        this.register("get", 2, e -> e.populate(ArrayGet::new, AnyItemType.getInstance(), 57344, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x2004000, null));
        this.register("head", 1, e -> e.populate(ArrayHead::new, AnyItemType.getInstance(), 57344, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
        this.register("insert-before", 3, e -> e.populate(ArrayInsertBefore::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x2004000, null).arg(2, AnyItemType.getInstance(), 0x800E000, null));
        this.register("join", 1, e -> e.populate(ArrayJoin::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x100E000, null));
        this.register("put", 3, e -> e.populate(ArrayPut::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x1004000, null).arg(2, AnyItemType.getInstance(), 0x800E000, null));
        this.register("remove", 2, e -> e.populate(ArrayRemove::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x200E000, null));
        this.register("reverse", 1, e -> e.populate(ArrayReverse::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
        this.register("size", 1, e -> e.populate(ArraySize::new, BuiltInAtomicType.INTEGER, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
        SpecificFunctionType sortFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE}, SequenceType.ATOMIC_SEQUENCE);
        this.register("sort", 1, e -> e.populate(ArraySort::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
        this.register("sort", 2, e -> e.populate(ArraySort::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.STRING, 0x2006000, null));
        this.register("sort", 3, e -> e.populate(ArraySort::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.STRING, 0x2006000, null).arg(2, sortFunctionType, 0x1004000, null));
        this.register("subarray", 2, e -> e.populate(ArraySubarray::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x2004000, null));
        this.register("subarray", 3, e -> e.populate(ArraySubarray::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x2004000, null).arg(2, BuiltInAtomicType.INTEGER, (version >= 40 ? 24576 : 16384) | 0x2000000, null));
        this.register("tail", 1, e -> e.populate(ArrayTail::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
        this.register("_to-sequence", 1, e -> e.populate(ArrayToSequence::new, AnyItemType.getInstance(), 57344, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
        this.register("_from-sequence", 1, e -> e.populate(ArrayFromSequence::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, AnyItemType.getInstance(), 0x100E000, null));
        if (version >= 40) {
            SpecificFunctionType fallbackType = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_INTEGER}, SequenceType.ANY_SEQUENCE);
            this.register("get", 3, e -> e.populate(ArrayGet::new, AnyItemType.getInstance(), 57344, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x2004000, null).arg(2, fallbackType, 0x1004000, null));
            this.register("empty", 1, e -> e.populate(ArrayEmpty::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
            this.register("exists", 1, e -> e.populate(ArrayExists::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
            this.register("foot", 1, e -> e.populate(ArrayFoot::new, AnyItemType.getInstance(), 57344, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
            this.register("index-where", 2, e -> e.populate(ArrayIndexWhere::new, BuiltInAtomicType.INTEGER, 57344, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, filterFunctionType, 0x1004000, null));
            this.register("slice", 1, 4, e -> e.populate(ArraySlice::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 24576, null).arg(2, BuiltInAtomicType.INTEGER, 24576, null).arg(3, BuiltInAtomicType.INTEGER, 24576, null));
            this.register("split", 1, 1, e -> e.populate(ArraySplit::new, ArrayItemType.ANY_ARRAY_TYPE, 57344, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 16384, null));
            this.register("replace", 3, e -> e.populate(ArrayReplace::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x2004000, null).arg(2, forEachFunctionType, 16384, null));
            this.register("trunk", 1, e -> e.populate(ArrayTrunk::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null));
            this.register("of-members", 1, e -> e.populate(ArrayOfMembers::new, ArrayItemType.ANY_ARRAY_TYPE, 16384, 262144).arg(0, Parcel.TYPE, 57344, null));
            this.register("members", 1, e -> e.populate(ArrayMembers::new, Parcel.TYPE, 57344, 262144).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 16384, null));
        }
    }

    @Override
    public NamespaceUri getNamespace() {
        return NamespaceUri.ARRAY_FUNCTIONS;
    }

    @Override
    public String getConventionalPrefix() {
        return "array";
    }

    public static int checkSubscript(IntegerValue subscript, int limit) throws XPathException {
        int index = subscript.asSubscript();
        if (index <= 0) {
            throw new XPathException("Array subscript " + subscript.getUnicodeStringValue() + " is out of range", "FOAY0001");
        }
        if (index > limit) {
            throw new XPathException("Array subscript " + subscript.getUnicodeStringValue() + " exceeds limit (" + limit + ")", "FOAY0001");
        }
        return index;
    }

    public static class ArrayFromSequence
    extends FoldingFunction
    implements Pingable {
        private double numberOfCalls = 0.0;
        private double numberOfConversions = 0.0;

        @Override
        public void ping() {
            this.numberOfConversions += 1.0;
        }

        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            if (this.numberOfConversions > Math.max(10.0, this.numberOfCalls * 0.5)) {
                return ImmutableArrayItem.from(arguments[0].iterate());
            }
            SimpleArrayItem result = SimpleArrayItem.makeSimpleArrayItem(arguments[0].iterate());
            result.requestNotification(this);
            this.numberOfCalls += 1.0;
            return result;
        }

        @Override
        public Fold getFold(XPathContext context, Sequence ... additionalArguments) {
            return new Fold(){
                final List<GroundedValue> members = new ArrayList<GroundedValue>();

                @Override
                public void processItem(Item item) {
                    this.members.add(item);
                }

                @Override
                public boolean isFinished() {
                    return false;
                }

                @Override
                public Sequence result() {
                    return new SimpleArrayItem(this.members);
                }
            };
        }
    }

    public static class ArrayToSequence
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            return ArrayToSequence.toSequence(array);
        }

        public static Sequence toSequence(ArrayItem array) throws XPathException {
            ZenoSequence results = new ZenoSequence();
            for (GroundedValue seq : array.members()) {
                results = results.appendSequence(seq);
            }
            return results;
        }
    }

    public static class ArrayIndexWhere
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array1 = (ArrayItem)arguments[0].head();
            assert (array1 != null);
            FunctionItem fn = (FunctionItem)arguments[1].head();
            ArrayList<Int64Value> list = new ArrayList<Int64Value>();
            for (int i = 0; i < array1.arrayLength(); ++i) {
                GroundedValue result = ArrayIndexWhere.dynamicCall(fn, context, array1.get(i)).materialize();
                if (!result.effectiveBooleanValue()) continue;
                list.add(new Int64Value(i + 1));
            }
            return SequenceExtent.makeSequenceExtent(list);
        }
    }

    public static class ArrayTrunk
    extends SystemFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            int len = array.arrayLength();
            if (len < 1) {
                throw new XPathException("Argument to array:trunk is an empty array", "FOAY0001");
            }
            return array.remove(len - 1);
        }
    }

    public static class ArraySplit
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem input = (ArrayItem)arguments[0].head();
            ArrayList<SimpleArrayItem> result = new ArrayList<SimpleArrayItem>();
            for (GroundedValue member : input.members()) {
                ArrayList<GroundedValue> subArray = new ArrayList<GroundedValue>();
                subArray.add(member);
                result.add(new SimpleArrayItem(subArray));
            }
            return SequenceExtent.makeSequenceExtent(result);
        }
    }

    public static class ArraySlice
    extends SystemFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            Item parcel;
            ArrayItem input = (ArrayItem)arguments[0].head();
            GroundedValue parcels = ArrayMembers.members(input);
            Sequence[] newArgs = Arrays.copyOf(arguments, arguments.length);
            newArgs[0] = parcels;
            GroundedValue slicedParcels = Slice.slice(newArgs);
            ArrayList<GroundedValue> members = new ArrayList<GroundedValue>(slicedParcels.getLength());
            SequenceIterator iter = slicedParcels.iterate();
            while ((parcel = iter.next()) != null) {
                members.add(UnparcelFn.unparcel(parcel, context));
            }
            return new SimpleArrayItem(members);
        }
    }

    public static class ArrayBuild
    extends ArrayGeneratingFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayList<GroundedValue> members = new ArrayList<GroundedValue>(this.expectedSize());
            SequenceIterator iter = arguments[0].iterate();
            if (arguments.length == 1) {
                try {
                    Item it;
                    while ((it = iter.next()) != null) {
                        members.add(it);
                    }
                }
                catch (UncheckedXPathException e) {
                    iter.close();
                    throw e.getXPathException();
                }
            }
            FunctionItem fn = (FunctionItem)arguments[1].head();
            try {
                Item it;
                while ((it = iter.next()) != null) {
                    members.add(ArrayBuild.dynamicCall(fn, context, it).materialize());
                }
            }
            catch (UncheckedXPathException e) {
                iter.close();
                throw e.getXPathException();
            }
            return this.makeArray(members);
        }
    }

    public static class ArrayOfMembers
    extends ArrayGeneratingFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            Item parcel;
            ArrayList<GroundedValue> members = new ArrayList<GroundedValue>(this.expectedSize());
            SequenceIterator parcels = arguments[0].iterate();
            while ((parcel = parcels.next()) != null) {
                members.add(UnparcelFn.unparcel(parcel, context));
            }
            return this.makeArray(members);
        }
    }

    public static class ArrayMembers
    extends SystemFunction {
        @Override
        public GroundedValue call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem input = (ArrayItem)arguments[0].head();
            return ArrayMembers.members(input);
        }

        public static GroundedValue members(ArrayItem input) {
            ArrayList<Parcel> parcels = new ArrayList<Parcel>(input.arrayLength());
            for (GroundedValue member : input.members()) {
                parcels.add(new Parcel(member));
            }
            return SequenceExtent.makeSequenceExtent(parcels);
        }
    }

    public static class ArrayTail
    extends SystemFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            if (array.arrayLength() < 1) {
                throw new XPathException("Argument to array:tail is an empty array", "FOAY0001");
            }
            return array.remove(0);
        }
    }

    public static class ArraySubarray
    extends SystemFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            int length;
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            int start = ArrayFunctionSet.checkSubscript((IntegerValue)arguments[1].head(), array.arrayLength() + 1);
            if (arguments.length == 3) {
                IntegerValue len = (IntegerValue)arguments[2].head();
                if (len == null) {
                    length = array.arrayLength() - start + 1;
                } else {
                    int signum = len.signum();
                    if (signum < 0) {
                        throw new XPathException("Specified length of subarray is less than zero", "FOAY0002");
                    }
                    length = signum == 0 ? 0 : ArrayFunctionSet.checkSubscript(len, array.arrayLength());
                }
            } else {
                length = array.arrayLength() - start + 1;
            }
            if (start < 1) {
                throw new XPathException("Start position is less than one", "FOAY0001");
            }
            if (start > array.arrayLength() + 1) {
                throw new XPathException("Start position is out of bounds", "FOAY0001");
            }
            if (start + length > array.arrayLength() + 1) {
                throw new XPathException("Specified length of subarray is too great for start position given", "FOAY0001");
            }
            return array.subArray(start - 1, start + length - 1);
        }
    }

    public static class ArraySize
    extends SystemFunction {
        @Override
        public IntegerValue call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            return new Int64Value(array.arrayLength());
        }
    }

    public static class ArrayReverse
    extends ArrayGeneratingFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            ArrayList<GroundedValue> list = new ArrayList<GroundedValue>(array.arrayLength());
            for (int i = 0; i < array.arrayLength(); ++i) {
                list.add(array.get(array.arrayLength() - i - 1));
            }
            return this.makeArray(list);
        }
    }

    public static class ArrayReplace
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            IntegerValue index = (IntegerValue)arguments[1].head();
            int pos = ArrayFunctionSet.checkSubscript(index, array.arrayLength()) - 1;
            GroundedValue oldVal = array.get(pos);
            FunctionItem fn = (FunctionItem)arguments[2].head();
            GroundedValue newVal = ArrayReplace.dynamicCall(fn, context, oldVal).materialize();
            return array.put(pos, newVal);
        }
    }

    public static class ArrayRemove
    extends SystemFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            GroundedValue offsets = arguments[1].materialize();
            if (offsets instanceof IntegerValue) {
                int index = ArrayFunctionSet.checkSubscript((IntegerValue)offsets, array.arrayLength()) - 1;
                return array.remove(index);
            }
            IntHashSet positions = new IntHashSet();
            SequenceIterator arg1 = offsets.iterate();
            SequenceTool.supply(arg1, pos -> {
                int index = ArrayFunctionSet.checkSubscript((IntegerValue)pos, array.arrayLength()) - 1;
                positions.add(index);
            });
            return array.removeSeveral(positions);
        }
    }

    public static class ArrayPut
    extends SystemFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            int index = ArrayFunctionSet.checkSubscript((IntegerValue)arguments[1].head(), array.arrayLength()) - 1;
            GroundedValue newVal = arguments[2].materialize();
            return array.put(index, newVal);
        }
    }

    public static class ArrayJoin
    extends SystemFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem nextArray;
            SequenceIterator iterator = arguments[0].iterate();
            ArrayItem array = SimpleArrayItem.EMPTY_ARRAY;
            while ((nextArray = (ArrayItem)iterator.next()) != null) {
                array = ((ArrayItem)array).concat(nextArray);
            }
            return array;
        }
    }

    public static class ArrayInsertBefore
    extends SystemFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            int index = ArrayFunctionSet.checkSubscript((IntegerValue)arguments[1].head(), array.arrayLength() + 1) - 1;
            if (index < 0 || index > array.arrayLength()) {
                throw new XPathException("Specified position is not in range", "FOAY0001");
            }
            Sequence newMember = arguments[2];
            return array.insert(index, newMember.materialize());
        }
    }

    public static class ArrayHead
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            if (array.arrayLength() == 0) {
                throw new XPathException("Argument to array:head is an empty array", "FOAY0001");
            }
            return array.get(0);
        }
    }

    public static class ArrayGet
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            IntegerValue index = (IntegerValue)arguments[1].head();
            if (arguments.length <= 2) {
                return array.get(ArrayFunctionSet.checkSubscript(index, array.arrayLength()) - 1);
            }
            int i = index.asSubscript();
            if (i <= 0 || i > array.arrayLength()) {
                FunctionItem fn = (FunctionItem)arguments[2].head();
                return ArrayGet.dynamicCall(fn, context, index);
            }
            return array.get(i - 1);
        }
    }

    public static class ArrayForEachPair
    extends ArrayGeneratingFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array1 = (ArrayItem)arguments[0].head();
            assert (array1 != null);
            ArrayItem array2 = (ArrayItem)arguments[1].head();
            assert (array2 != null);
            FunctionItem fn = (FunctionItem)arguments[2].head();
            ArrayList<GroundedValue> list = new ArrayList<GroundedValue>(this.expectedSize());
            for (int i = 0; i < array1.arrayLength() && i < array2.arrayLength(); ++i) {
                list.add(ArrayForEachPair.dynamicCall(fn, context, array1.get(i), array2.get(i)).materialize());
            }
            return this.makeArray(list);
        }
    }

    public static class ArrayForEach
    extends ArrayGeneratingFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            FunctionItem fn = (FunctionItem)arguments[1].head();
            ArrayList<GroundedValue> list = new ArrayList<GroundedValue>(this.expectedSize());
            for (GroundedValue gv : array.members()) {
                list.add(ArrayForEach.dynamicCall(fn, context, gv).materialize());
            }
            return this.makeArray(list);
        }
    }

    public static class ArrayFoot
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            int len = array.arrayLength();
            if (len == 0) {
                throw new XPathException("Argument to array:foot is an empty array", "FOAY0001");
            }
            return array.get(len - 1);
        }
    }

    public static class ArrayEmpty
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            int len = array.arrayLength();
            return BooleanValue.get(len == 0);
        }
    }

    public static class ArrayExists
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            int len = array.arrayLength();
            return BooleanValue.get(len > 0);
        }
    }

    public static class ArrayFoldRight
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            Sequence zero = arguments[1];
            FunctionItem fn = (FunctionItem)arguments[2].head();
            for (int i = array.arrayLength() - 1; i >= 0; --i) {
                zero = ArrayFoldRight.dynamicCall(fn, context, array.get(i), zero);
            }
            return zero;
        }
    }

    public static class ArrayFoldLeft
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            int arraySize = array.arrayLength();
            Sequence zero = arguments[1];
            FunctionItem fn = (FunctionItem)arguments[2].head();
            for (int i = 0; i < arraySize; ++i) {
                zero = ArrayFoldLeft.dynamicCall(fn, context, zero, array.get(i));
            }
            return zero;
        }
    }

    public static class ArrayFlatten
    extends SystemFunction {
        private void flatten(Sequence arg, List<Item> out) {
            SequenceTool.supply(arg.iterate(), item -> {
                if (item instanceof ArrayItem) {
                    for (GroundedValue member : ((ArrayItem)item).members()) {
                        this.flatten(member, out);
                    }
                } else {
                    out.add(item);
                }
            });
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayList<Item> out = new ArrayList<Item>();
            this.flatten(arguments[0], out);
            return SequenceExtent.makeSequenceExtent(out);
        }
    }

    public static class ArrayFilter
    extends ArrayGeneratingFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            FunctionItem fn = (FunctionItem)arguments[1].head();
            ArrayList<GroundedValue> list = new ArrayList<GroundedValue>(this.expectedSize());
            for (GroundedValue gv : array.members()) {
                if (!((BooleanValue)ArrayFilter.dynamicCall(fn, context, gv).head()).getBooleanValue()) continue;
                list.add(gv);
            }
            return this.makeArray(list);
        }
    }

    public static class ArrayAppend
    extends SystemFunction {
        @Override
        public ArrayItem call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            assert (array != null);
            return array.append(arguments[1].materialize());
        }
    }

    public static abstract class ArrayGeneratingFunction
    extends SystemFunction
    implements Pingable {
        private double numberOfCalls = 0.0;
        private double numberOfConversions = 0.0;
        private double totalSize = 0.0;

        @Override
        public void ping() {
            this.numberOfConversions += 1.0;
        }

        protected int expectedSize() {
            return this.numberOfCalls < 10.0 ? 10 : (int)(this.totalSize / this.numberOfCalls * 1.05);
        }

        protected ArrayItem makeArray(List<GroundedValue> members) {
            if (this.numberOfConversions > Math.max(10.0, this.numberOfCalls * 0.5)) {
                return new ImmutableArrayItem(members);
            }
            this.numberOfCalls += 1.0;
            this.totalSize += (double)members.size();
            SimpleArrayItem result = new SimpleArrayItem(members);
            result.requestNotification(this);
            return result;
        }
    }
}

