/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserDefinedType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public abstract class SchemaStructure
implements Location {
    private String systemId;
    private int lineNumber;
    private String generatedId;
    private String schemaDocumentURI;
    private SchemaComponent.ValidationStatus fixupStatus = SchemaComponent.ValidationStatus.UNVALIDATED;
    private SchemaComponent.ValidationStatus validationStatus = SchemaComponent.ValidationStatus.UNVALIDATED;
    private EnterpriseConfiguration config;
    private int redefinitionLevel = 0;

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    public void setLocator(SourceLocator locator) {
        if (locator != null) {
            this.systemId = locator.getSystemId();
            this.lineNumber = locator.getLineNumber();
            if (locator instanceof NodeInfo) {
                this.generatedId = Navigator.getPath((NodeInfo)locator);
            }
        }
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setSchemaDocumentURI(String uri) {
        this.schemaDocumentURI = uri;
    }

    public String getSchemaDocumentURI() {
        return this.schemaDocumentURI;
    }

    public void setGeneratedId(String generatedId) {
        this.generatedId = generatedId;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public SchemaComponent.ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public boolean isValidationNeeded() {
        return this.validationStatus == SchemaComponent.ValidationStatus.UNVALIDATED;
    }

    public void setValidationStatus(SchemaComponent.ValidationStatus status) {
        this.validationStatus = status;
    }

    public SchemaComponent.ValidationStatus getFixupStatus() {
        return this.fixupStatus;
    }

    public void setFixupStatus(SchemaComponent.ValidationStatus status) {
        this.fixupStatus = status;
    }

    public void setConfiguration(EnterpriseConfiguration config) {
        this.config = config;
    }

    public EnterpriseConfiguration getConfiguration() {
        return this.config;
    }

    public void setRedefinitionLevel(int level) {
        this.redefinitionLevel = level;
    }

    public int getRedefinitionLevel() {
        return this.redefinitionLevel;
    }

    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException {
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        return true;
    }

    public void elaborate(SchemaCompiler compiler) throws SchemaException {
    }

    protected static Function makeXPathExpressionPropertyRecord(String conditionText, NamespaceResolver nsResolver, String baseURI) {
        Callable callable = (context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "namespace bindings": {
                    ArrayList<CallableFunction> bindings = new ArrayList<CallableFunction>();
                    Iterator<String> prefixes = nsResolver.iteratePrefixes();
                    while (prefixes.hasNext()) {
                        String prefix = prefixes.next();
                        Callable binding = (context1, arguments1) -> {
                            String key1;
                            switch (key1 = arguments1[0].head().getStringValue()) {
                                case "prefix": {
                                    return new StringValue(prefix);
                                }
                                case "namespace": {
                                    return new AnyURIValue(nsResolver.getURIForPrefix(prefix, false));
                                }
                            }
                            return EmptySequence.getInstance();
                        };
                        bindings.add(new CallableFunction(1, binding, SchemaComponent.COMPONENT_FUNCTION_TYPE));
                    }
                    return SequenceExtent.makeSequenceExtent(bindings);
                }
                case "default namespace": {
                    return new AnyURIValue(nsResolver.getURIForPrefix("", true));
                }
                case "base URI": {
                    return new AnyURIValue(baseURI);
                }
                case "expression": {
                    return new StringValue(conditionText);
                }
            }
            return EmptySequence.getInstance();
        };
        return new CallableFunction(1, callable, SchemaComponent.COMPONENT_FUNCTION_TYPE);
    }

    public boolean hasSameLocation(SchemaStructure other) {
        if (!UserDefinedType.isSameURI(this.getSystemId(), other.getSystemId())) {
            return false;
        }
        if (this.getLineNumber() >= 0 && other.getLineNumber() >= 0) {
            return this.getLineNumber() == other.getLineNumber() && this.getColumnNumber() == other.getColumnNumber();
        }
        return this.generatedId != null && other.generatedId != null && this.generatedId.equals(other.generatedId);
    }
}

