/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import marmot.util.FileUtils;

public class Sys {
    private static final long ONE_MEGA_BYTES_IN_BYTES = 0x100000L;

    public static long getUsedMemoryInBytes() {
        Runtime r = Runtime.getRuntime();
        r.gc();
        return r.totalMemory() - r.freeMemory();
    }

    public static double getUsedMemoryInMegaBytes() {
        return (double)Sys.getUsedMemoryInBytes() / 1048576.0;
    }

    public static long getUsedMemoryInBytes(Serializable object, boolean compress) {
        try {
            File file = File.createTempFile("memory", "ser");
            FileUtils.saveToFile(object, file, compress);
            long length = file.length();
            file.deleteOnExit();
            return length;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getMaxHeapSizeInBytes() {
        Runtime r = Runtime.getRuntime();
        return r.maxMemory();
    }

    public static double getMaxHeapSizeInMegaBytes() {
        return (double)Sys.getMaxHeapSizeInBytes() / 1048576.0;
    }

    public static double getUsedMemoryInMegaBytes(Serializable object, boolean compress) {
        return (double)Sys.getUsedMemoryInBytes(object, compress) / 1048576.0;
    }
}

