/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.DeleteAction;
import com.saxonica.ee.update.InsertAction;
import com.saxonica.ee.update.InsertAttributeAction;
import com.saxonica.ee.update.PendingUpdateAction;
import com.saxonica.ee.update.PutAction;
import com.saxonica.ee.update.RenameAction;
import com.saxonica.ee.update.ReplaceAttributeAction;
import com.saxonica.ee.update.ReplaceNodeAction;
import com.saxonica.ee.update.ReplaceValueAction;
import com.saxonica.ee.validate.InSituValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.MutableDocumentInfo;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.z.IntHashMap;

public class PendingUpdateListImpl
implements PendingUpdateList {
    private Configuration config;
    private IntHashMap<List<PendingUpdateAction>> lists = new IntHashMap(7);
    private Set<MutableNodeInfo> affectedTrees = new HashSet<MutableNodeInfo>();
    private Set<NodeInfo> renamedNodes = new HashSet<NodeInfo>();
    private Set<NodeInfo> replacedNodes = new HashSet<NodeInfo>();
    private Set<NodeInfo> replacedValueNodes = new HashSet<NodeInfo>();
    private Map<NodeInfo, Map<String, String>> newNamespaceBindings = new HashMap<NodeInfo, Map<String, String>>();
    private Set<String> putURIs = new HashSet<String>();
    private Map<NodeInfo, List<PendingUpdateAction>> attributeActions = new HashMap<NodeInfo, List<PendingUpdateAction>>();
    private Set<PackageData> packages = new HashSet<PackageData>();

    public PendingUpdateListImpl(Configuration config) {
        this.config = config;
    }

    public void add(PendingUpdateAction action) throws XPathException {
        NamePool pool = this.config.getNamePool();
        int phase = action.getApplyPhase();
        if (this.lists.get(phase) == null) {
            this.lists.put(phase, new ArrayList(4));
        }
        if (action instanceof RenameAction) {
            boolean added = this.renamedNodes.add(action.getTargetNode());
            if (!added) {
                throw this.conflict("rename", "XUDY0015", action.getTargetNode());
            }
            NodeName newName = ((RenameAction)action).getNewName();
            NamespaceBinding nsCode = new NamespaceBinding(newName.getPrefix(), newName.getURI());
            NodeInfo targetNode = action.getTargetNode();
            int nodeKind = targetNode.getNodeKind();
            if (nodeKind == 2) {
                NodeInfo parent = targetNode.getParent();
                this.addAttributeAction(parent, action);
                targetNode = parent;
            } else if (nodeKind == 7) {
                targetNode = null;
            }
            this.checkForNamespaceConflict(targetNode, nodeKind, nsCode, action);
            if (nodeKind != 2) {
                this.lists.get(phase).add(action);
            }
        } else if (action instanceof ReplaceNodeAction) {
            boolean added = this.replacedNodes.add(action.getTargetNode());
            if (!added) {
                throw this.conflict("replace", "XUDY0016", action.getTargetNode());
            }
            this.lists.get(phase).add(action);
        } else if (action instanceof ReplaceAttributeAction) {
            NodeInfo element = action.getTargetNode();
            NodeInfo oldAtt = ((ReplaceAttributeAction)action).getOldAttribute();
            boolean added = this.replacedNodes.add(oldAtt);
            if (!added) {
                throw this.conflict("replace", "XUDY0016", oldAtt);
            }
            this.addAttributeAction(element, action);
            SameNameTest test = new SameNameTest(oldAtt);
            AttributeCollection newAtts = ((ReplaceAttributeAction)action).getNewAttributes();
            for (int i = 0; i < newAtts.getLength(); ++i) {
                if (test.matches(newAtts.getNodeName(i).getStructuredQName())) continue;
                NamespaceBinding nsBinding = new NamespaceBinding(newAtts.getPrefix(i), newAtts.getURI(i));
                this.checkForNamespaceConflict(element, 2, nsBinding, action);
            }
        } else if (action instanceof ReplaceValueAction) {
            boolean added = this.replacedValueNodes.add(action.getTargetNode());
            if (!added) {
                throw this.conflict("replace the value of", "XUDY0017", action.getTargetNode());
            }
            this.lists.get(phase).add(action);
        } else if (action instanceof InsertAttributeAction) {
            NodeName name = ((InsertAttributeAction)action).getAttributeName();
            NamespaceBinding nsCode = new NamespaceBinding(name.getPrefix(), name.getURI());
            NodeInfo targetNode = action.getTargetNode();
            this.addAttributeAction(targetNode, action);
            this.checkForNamespaceConflict(targetNode, 2, nsCode, action);
        } else if (action instanceof InsertAction) {
            this.lists.get(phase).add(action);
        } else if (action instanceof DeleteAction) {
            NodeInfo targetNode = action.getTargetNode();
            if (targetNode.getNodeKind() == 2) {
                NodeInfo parent = targetNode.getParent();
                if (parent != null) {
                    this.addAttributeAction(parent, action);
                }
            } else {
                this.lists.get(phase).add(action);
            }
        } else if (action instanceof PutAction) {
            this.lists.get(phase).add(action);
        }
        this.packages.add(action.getOriginator().getPackageData());
    }

    private void addAttributeAction(NodeInfo element, PendingUpdateAction action) {
        List actions = this.attributeActions.computeIfAbsent(element, k -> new ArrayList(2));
        actions.add(action);
        this.packages.add(action.getOriginator().getPackageData());
    }

    @Override
    public void addPutAction(NodeInfo node, String uri, Expression originator) throws XPathException {
        if (!this.putURIs.add(uri)) {
            XPathException err1 = new XPathException("Cannot put() two documents to the same URI (" + uri + ")");
            err1.setErrorCode("XUDY0031");
            err1.setIsTypeError(false);
            err1.setLocation(originator.getLocation());
            throw err1;
        }
        PutAction action = new PutAction(node, uri);
        action.setOriginator(originator);
        this.add(action);
    }

    private void checkForNamespaceConflict(NodeInfo targetNode, int nodeKind, NamespaceBinding nsCode, PendingUpdateAction action) throws XPathException {
        if (!(targetNode == null || nodeKind != 1 && nsCode.getPrefix().isEmpty())) {
            String prefix = nsCode.getPrefix();
            String uri = nsCode.getURI();
            Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(targetNode);
            while (iter.hasNext()) {
                NamespaceBinding oldNsCode = iter.next();
                if (!oldNsCode.getPrefix().equals(prefix) || oldNsCode.getURI().isEmpty() || oldNsCode.getURI().equals(uri)) continue;
                XPathException err1 = new XPathException("An update action creates a namespace binding that conflicts with an existing namespace binding on the same target element");
                err1.setErrorCode("XUDY0023");
                err1.setIsTypeError(false);
                err1.setLocation(action.getOriginator().getLocation());
                throw err1;
            }
            Map<String, String> nsmap = this.newNamespaceBindings.get(targetNode);
            if (nsmap == null) {
                nsmap = new HashMap<String, String>();
                this.newNamespaceBindings.put(targetNode, nsmap);
                nsmap.put(prefix, uri);
            } else {
                String existingUri = nsmap.get(prefix);
                if (existingUri == null) {
                    nsmap.put(prefix, uri);
                } else if (!existingUri.equals(uri)) {
                    XPathException err1 = new XPathException("Two updates create conflicting namespace bindings on the same target node");
                    err1.setErrorCode("XUDY0024");
                    err1.setIsTypeError(false);
                    throw err1;
                }
            }
        }
    }

    private XPathException conflict(String action, String errorCode, NodeInfo node) {
        int kind = node.getNodeKind();
        String kindStr = NodeKindTest.toString(kind);
        if (kind == 1) {
            kindStr = Err.wrap(node.getDisplayName(), 1) + " " + kindStr;
        } else if (kind == 2) {
            kindStr = Err.wrap(node.getDisplayName(), 2) + " " + kindStr;
        }
        String msg = "Update conflict: two attempts to " + action + " the same " + kindStr + " node";
        if (node.getLineNumber() != -1) {
            msg = msg + ". Node at line " + node.getLineNumber() + " of " + node.getSystemId();
        }
        return new XPathException(msg, errorCode);
    }

    private void finalCheck() throws XPathException {
        for (Map.Entry<NodeInfo, List<PendingUpdateAction>> e : this.attributeActions.entrySet()) {
            MutableNodeInfo element = (MutableNodeInfo)e.getKey();
            this.checkAttributeActions(element, e.getValue());
            this.affectedTrees.add((MutableNodeInfo)element.getRoot());
        }
    }

    @Override
    public synchronized void apply(XPathContext context, int validationMode) throws XPathException {
        this.finalCheck();
        for (int phase = 0; phase < 6; ++phase) {
            Collection list = this.lists.get(phase);
            if (list == null) continue;
            for (Object action : list) {
                ((PendingUpdateAction)action).apply(context, this.affectedTrees);
            }
        }
        for (Map.Entry<NodeInfo, List<PendingUpdateAction>> e : this.attributeActions.entrySet()) {
            MutableNodeInfo element = (MutableNodeInfo)e.getKey();
            if (element.isDeleted()) continue;
            this.applyAttributeActions(element, e.getValue());
            this.affectedTrees.add((MutableNodeInfo)element.getRoot());
        }
        Collection list = this.lists.get(6);
        if (list != null) {
            for (PendingUpdateAction action : list) {
                action.apply(context, this.affectedTrees);
            }
        }
        for (MutableNodeInfo root : this.affectedTrees) {
            if (!(root instanceof MutableDocumentInfo)) continue;
            for (PackageData packageData : this.packages) {
                packageData.getKeyManager().clearDocumentIndexes(root.getTreeInfo());
            }
            ((MutableDocumentInfo)((Object)root)).resetIndexes();
        }
        if (validationMode == 1 || validationMode == 2) {
            for (MutableNodeInfo root : this.affectedTrees) {
                InSituValidator validator = new InSituValidator(root, validationMode);
                validator.validate();
            }
        }
    }

    private void checkAttributeActions(MutableNodeInfo element, List<PendingUpdateAction> actions) throws XPathException {
        NodeInfo att;
        HashMap<NodeName, Integer> names = new HashMap<NodeName, Integer>();
        AxisIterator attributes = element.iterateAxis((byte)2);
        while ((att = attributes.next()) != null) {
            names.put(NameOfNode.makeName(att), 1);
        }
        for (PendingUpdateAction action : actions) {
            Integer countVal;
            NodeName nameOfNode;
            if (action instanceof DeleteAction) {
                nameOfNode = NameOfNode.makeName(action.getTargetNode());
                countVal = (Integer)names.get(nameOfNode);
                int count = countVal == null ? 0 : countVal;
                if (count <= 0) continue;
                names.put(nameOfNode, count - 1);
                continue;
            }
            if (action instanceof RenameAction) {
                int count;
                nameOfNode = NameOfNode.makeName(action.getTargetNode());
                countVal = (Integer)names.get(nameOfNode);
                int n = count = countVal == null ? 0 : countVal;
                if (count > 0) {
                    names.put(nameOfNode, count - 1);
                }
                count = (countVal = (Integer)names.get(nameOfNode = ((RenameAction)action).getNewName())) == null ? 0 : countVal;
                names.put(nameOfNode, count + 1);
                continue;
            }
            if (action instanceof ReplaceAttributeAction) {
                int count;
                NodeInfo target = ((ReplaceAttributeAction)action).getOldAttribute();
                NodeName nameOfNode2 = NameOfNode.makeName(target);
                Integer countVal2 = (Integer)names.get(nameOfNode2);
                int n = count = countVal2 == null ? 0 : countVal2;
                if (count > 0) {
                    names.put(nameOfNode2, count - 1);
                }
                AttributeCollection newNodes = ((ReplaceAttributeAction)action).getNewAttributes();
                for (int i = 0; i < newNodes.getLength(); ++i) {
                    nameOfNode2 = newNodes.getNodeName(i);
                    countVal2 = (Integer)names.get(nameOfNode2);
                    count = countVal2 == null ? 0 : countVal2;
                    names.put(nameOfNode2, count + 1);
                }
                continue;
            }
            if (!(action instanceof InsertAttributeAction)) continue;
            nameOfNode = ((InsertAttributeAction)action).getAttributeName();
            countVal = (Integer)names.get(nameOfNode);
            int count = countVal == null ? 0 : countVal;
            names.put(nameOfNode, count + 1);
        }
        for (NodeName nn : names.keySet()) {
            int count = (Integer)names.get(nn);
            if (count <= 1) continue;
            throw new XPathException("After applying all updates, the element at " + Navigator.getPath(element) + " would have " + (count == 2 ? "two" : Integer.valueOf(count)) + " attributes named " + nn.getStructuredQName().getEQName(), "XUDY0021");
        }
    }

    private void applyAttributeActions(MutableNodeInfo element, List<PendingUpdateAction> actions) {
        for (PendingUpdateAction action : actions) {
            if (!(action instanceof DeleteAction)) continue;
            ((MutableNodeInfo)action.getTargetNode()).delete();
        }
        for (PendingUpdateAction action : actions) {
            if (!(action instanceof ReplaceAttributeAction)) continue;
            NodeInfo nodeInfo = ((ReplaceAttributeAction)action).getOldAttribute();
            ((MutableNodeInfo)nodeInfo).delete();
        }
        HashMap<MutableNodeInfo, NodeName> pendingRenames = null;
        for (PendingUpdateAction pendingUpdateAction : actions) {
            if (!(pendingUpdateAction instanceof RenameAction)) continue;
            NodeName nc = ((RenameAction)pendingUpdateAction).getNewName();
            FingerprintedQName newName = null;
            if (element.getAttributeValue(nc.getURI(), nc.getLocalPart()) != null) {
                String candidate;
                int n = 1;
                while (true) {
                    candidate = nc.getLocalPart() + n;
                    if (element.getAttributeValue(nc.getURI(), candidate) == null) break;
                    ++n;
                }
                newName = new FingerprintedQName(nc.getPrefix(), nc.getURI(), candidate);
                if (pendingRenames == null) {
                    pendingRenames = new HashMap<MutableNodeInfo, NodeName>();
                }
                pendingRenames.put((MutableNodeInfo)pendingUpdateAction.getTargetNode(), nc);
                nc = newName;
            }
            ((MutableNodeInfo)pendingUpdateAction.getTargetNode()).rename(nc);
        }
        if (pendingRenames != null) {
            for (Map.Entry entry : pendingRenames.entrySet()) {
                ((MutableNodeInfo)entry.getKey()).rename((NodeName)entry.getValue());
            }
        }
        for (PendingUpdateAction pendingUpdateAction : actions) {
            if (!(pendingUpdateAction instanceof ReplaceAttributeAction)) continue;
            AttributeCollection content = ((ReplaceAttributeAction)pendingUpdateAction).getNewAttributes();
            for (int i = 0; i < content.getLength(); ++i) {
                element.addAttribute(content.getNodeName(i), content.getTypeAnnotation(i), content.getValue(i), 0);
            }
        }
        for (PendingUpdateAction pendingUpdateAction : actions) {
            if (!(pendingUpdateAction instanceof InsertAttributeAction)) continue;
            InsertAttributeAction a = (InsertAttributeAction)pendingUpdateAction;
            element.addAttribute(a.getAttributeName(), a.getNewTypeCode(), a.getNewStringValue(), 0);
        }
        element.removeTypeAnnotation();
    }

    @Override
    public Set<MutableNodeInfo> getAffectedTrees() {
        return this.affectedTrees;
    }
}

