/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.lemmatizer;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.lemmatizer.TrainingParams;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.lemmatizer.LemmatizerFactory;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.lemmatizer.LemmatizerModel;
import opennlp.tools.util.model.ModelUtil;

public class LemmatizerTrainerTool
extends AbstractTrainerTool<LemmaSample, TrainerToolParams> {
    public LemmatizerTrainerTool() {
        super(LemmaSample.class, TrainerToolParams.class);
    }

    @Override
    public String getName() {
        return "LemmatizerTrainerME";
    }

    @Override
    public String getShortDescription() {
        return "Trainer for the learnable lemmatizer";
    }

    @Override
    public void run(String format, String[] args2) {
        LemmatizerModel model;
        super.run(format, args2);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("lemmatizer model", modelOutFile);
        try {
            LemmatizerFactory lemmatizerFactory = LemmatizerFactory.create(((TrainerToolParams)this.params).getFactory());
            model = LemmatizerME.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, this.mlParams, lemmatizerFactory);
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("lemmatizer", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

