/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.AssertionFacet;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.PreprocessFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.sdoc.SaxonPreprocess;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDAssert;
import com.saxonica.ee.schema.sdoc.XSDFacet;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.z.IntHashSet;

public class XSDSimpleTypeRestriction
extends SchemaElement {
    private SimpleTypeDefinition typeDefinition = null;
    private boolean foundBase = false;
    private static final int[] state0terms = new int[]{609, 595, 605, 621, 578, 614, 592, 604, 608, 601, 626, 603, 607, 622, 623, 583, 277, 610, 606};
    private static final int[] state0targets = new int[]{1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] state1terms = new int[]{609, 595, 605, 614, 592, 604, 608, 601, 626, 603, 607, 622, 623, 583, 610, 606, 277};
    private static final int[] state1targets = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] state2terms = new int[]{609, 595, 605, 614, 592, 604, 608, 601, 626, 603, 607, 622, 623, 583, 610, 606, 277};
    private static final int[] state2targets = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] state3terms = new int[]{609, 595, 605, 621, 614, 592, 604, 608, 601, 626, 603, 607, 622, 623, 583, 610, 606, 277};
    private static final int[] state3targets = new int[]{1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets};

    @Override
    public void prepareAttributes() throws SchemaException {
        this.typeDefinition = this.getContainingSimpleType();
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"base", "id"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String base = atts.getValue("", "base");
        boolean bl = this.foundBase = base != null;
        if (this.foundBase) {
            int baseFingerprint;
            try {
                baseFingerprint = this.getFingerprint(base, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            this.checkPermittedType(baseFingerprint, base, "a base type");
            TypeReference ref = new TypeReference(baseFingerprint, this.typeDefinition.getConfiguration(), this);
            this.typeDefinition.setBaseTypeReference(ref);
        }
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        this.checkContentModel(stateTerms, stateTargets, false);
        boolean foundSimpleType = false;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            int fp = child.getFingerprint();
            if (fp != 621) continue;
            foundSimpleType = true;
            if (!this.foundBase) continue;
            this.mutuallyExclusiveElementAndAttribute("simpleType", "base");
            return;
        }
        if (!this.foundBase && !foundSimpleType) {
            this.error("A restriction element must either have a 'base' attribute or contain a 'simpleType' definition");
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return state == 0 || state == 1 || state == 2 || state == 3;
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        IntHashSet facetsSeen = new IntHashSet();
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            if (this.typeDefinition == null) continue;
            int fp = child.getFingerprint();
            switch (fp) {
                case 578: {
                    break;
                }
                case 621: {
                    SimpleTypeDefinition type = ((XSDSimpleType)child).getSimpleTypeDefinition();
                    TypeReference ref = new TypeReference(type.getFingerprint(), compiler.getConfiguration(), this);
                    this.typeDefinition.setBaseTypeReference(ref);
                    break;
                }
                case 580: 
                case 584: 
                case 585: {
                    break;
                }
                case 583: {
                    if (compiler.getLanguageVersion() == 10) {
                        this.error("To use xs:assertion, you must set xsdversion=1.1");
                    }
                    Assertion assertion = ((XSDAssert)child).getAssertion();
                    AssertionFacet af = new AssertionFacet(assertion);
                    af.setMessage(assertion.getMessage());
                    this.typeDefinition.addFacet(af);
                    break;
                }
                case 595: 
                case 601: 
                case 603: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 608: 
                case 609: 
                case 610: 
                case 622: 
                case 623: 
                case 626: {
                    if (facetsSeen.contains(fp)) {
                        this.error("The " + child.getDisplayName() + " facet must not appear more than once");
                    }
                    facetsSeen.add(fp);
                }
                case 592: 
                case 614: {
                    Facet facet = ((XSDFacet)child).getFacet();
                    if (facet == null) break;
                    this.typeDefinition.addFacet(facet);
                    break;
                }
                case 277: {
                    if (compiler.getLanguageVersion() == 10) {
                        this.error("To use saxon:preprocess, you must set xsdversion=1.1");
                    }
                    Assertion action = ((SaxonPreprocess)child).getAction();
                    Assertion reverseAction = ((SaxonPreprocess)child).getReverseAction();
                    PreprocessFacet af2 = new PreprocessFacet(action, reverseAction);
                    this.typeDefinition.addFacet(af2);
                    break;
                }
            }
        }
    }
}

