/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.domino;

import com.saxonica.ee.domino.DominoNode;
import com.saxonica.ee.domino.DominoTree;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.z.IntPredicateProxy;

final class SiblingIterator
implements AxisIterator,
LookaheadIterator {
    private final DominoTree tree;
    private int nextNodeNr;
    private final NodeTest test;
    private final DominoNode startNode;
    private final DominoNode parentNode;
    private final boolean getChildren;
    private boolean needToAdvance = false;
    private final IntPredicateProxy matcher;

    SiblingIterator(DominoTree tree, DominoNode node, NodeTest nodeTest, boolean getChildren) {
        this.tree = tree;
        this.test = nodeTest;
        this.matcher = nodeTest.getMatcher(tree);
        this.startNode = node;
        this.getChildren = getChildren;
        if (getChildren) {
            this.parentNode = node;
            this.nextNodeNr = node.getNodeNr() + 1;
        } else {
            this.parentNode = node.getParent();
            if (this.parentNode == null) {
                this.nextNodeNr = -1;
            } else {
                this.nextNodeNr = tree.next[node.getNodeNr()];
                if (this.nextNodeNr < node.getNodeNr()) {
                    this.nextNodeNr = -1;
                }
            }
        }
        if (this.nextNodeNr >= 0 && nodeTest != null && !this.matcher.test(this.nextNodeNr)) {
            this.needToAdvance = true;
        }
    }

    @Override
    public NodeInfo next() {
        if (this.needToAdvance) {
            int thisNode = this.nextNodeNr;
            int[] tNext = this.tree.next;
            NodeTest nTest = this.test;
            if (nTest == null) {
                do {
                    this.nextNodeNr = tNext[this.nextNodeNr];
                } while (this.tree.getNodeKind(this.nextNodeNr) == 12);
            } else {
                do {
                    this.nextNodeNr = tNext[this.nextNodeNr];
                } while (this.nextNodeNr >= thisNode && !this.matcher.test(this.nextNodeNr));
            }
            if (this.nextNodeNr < thisNode) {
                this.nextNodeNr = -1;
                this.needToAdvance = false;
                return null;
            }
        }
        if (this.nextNodeNr == -1) {
            return null;
        }
        this.needToAdvance = true;
        DominoNode nextNode = this.tree.getNode(this.nextNodeNr);
        nextNode.setParentNode(this.parentNode);
        return nextNode;
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        int n = this.nextNodeNr;
        if (this.needToAdvance) {
            NodeTest nTest = this.test;
            int[] tNext = this.tree.next;
            if (nTest == null) {
                while (this.tree.nodeKind[n = tNext[n]] == 12) {
                }
            } else {
                while ((n = tNext[n]) >= this.nextNodeNr && !this.matcher.test(n)) {
                }
            }
            if (n < this.nextNodeNr) {
                return false;
            }
        }
        return n != -1;
    }
}

