/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.domino;

import com.saxonica.ee.domino.DescendantIterator;
import com.saxonica.ee.domino.DominoAttr;
import com.saxonica.ee.domino.DominoTree;
import com.saxonica.ee.domino.FollowingIterator;
import com.saxonica.ee.domino.PrecedingIterator;
import com.saxonica.ee.domino.PrecedingSiblingIterator;
import com.saxonica.ee.domino.SiblingIterator;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodePredicate;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.NodeListIterator;
import net.sf.saxon.tree.iter.PrependAxisIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.tiny.AncestorIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.value.StringValue;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DominoNode
implements NodeInfo,
VirtualNode {
    private final DominoTree tree;
    private final int nodeNr;
    private DominoNode parent;

    public DominoNode(DominoTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    public DominoNode(DominoTree tree, int nodeNr, DominoNode parent) {
        this.tree = tree;
        this.nodeNr = nodeNr;
        this.parent = parent;
    }

    public final int getNodeNr() {
        return this.nodeNr;
    }

    protected void setParentNode(DominoNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return true;
    }

    public Node getDomNode() {
        return this.tree.getDomNode(this.nodeNr);
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof DominoNode) {
            int c = this.nodeNr - ((DominoNode)other).nodeNr;
            return Integer.compare(c, 0);
        }
        if (other instanceof DominoAttr) {
            return -other.compareOrder(this);
        }
        if (other instanceof NamespaceNode) {
            return -other.compareOrder(this);
        }
        throw new AssertionError(other.getClass());
    }

    public boolean isAncestorOrSelf(NodeInfo d) {
        if (d instanceof DominoAttr) {
            return this.isAncestorOrSelf(d.getParent());
        }
        if (d instanceof DominoNode) {
            if (this.tree != ((DominoNode)d).tree) {
                return false;
            }
            int dn = ((DominoNode)d).nodeNr;
            if (this.nodeNr > dn) {
                return false;
            }
            if (this.nodeNr == dn) {
                return true;
            }
            if (!this.hasChildNodes()) {
                return false;
            }
            if (this.tree.depth[this.nodeNr] >= this.tree.depth[dn]) {
                return false;
            }
            int n = this.nodeNr;
            while (true) {
                int nextSib;
                if ((nextSib = this.tree.next[n]) < 0 || nextSib > dn) {
                    return true;
                }
                if (this.tree.depth[nextSib] == 0) {
                    return true;
                }
                if (nextSib >= n) break;
                n = nextSib;
            }
            return false;
        }
        return false;
    }

    @Override
    public void generateId(StringBuilder buffer) {
        buffer.append("d");
        buffer.append(Long.toString(this.tree.getDocumentNumber()));
        buffer.append(TinyNodeImpl.NODE_LETTER[this.getNodeKind()]);
        buffer.append(Integer.toString(this.nodeNr));
    }

    @Override
    public String getAttributeValue(NamespaceUri uri, String local) {
        if (this.hasAttributes()) {
            String ns = uri.isEmpty() ? null : uri.toString();
            Node att = this.getDomNode().getAttributes().getNamedItemNS(ns, local);
            return att == null ? null : att.getNodeValue();
        }
        return null;
    }

    @Override
    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamespaceMap getAllNamespaces() {
        return this.tree.getNamespaceMap(this.nodeNr);
    }

    @Override
    public String getDisplayName() {
        if (this.getNodeKind() == 1) {
            return this.getDomNode().getNodeName();
        }
        if (this.getNodeKind() == 7) {
            return this.getLocalPart();
        }
        return "";
    }

    @Override
    public int getFingerprint() {
        return this.tree.getFingerprint(this.nodeNr);
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public String getLocalPart() {
        try {
            int f = this.getFingerprint();
            return f == -1 ? "" : this.tree.getNamePool().getLocalName(f);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getNodeKind() {
        return this.tree.getNodeKind(this.nodeNr);
    }

    @Override
    public DominoNode getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        int p = this.tree.getParentNodeNr(this.nodeNr);
        this.parent = p == -1 ? null : this.tree.getNode(p);
        return this.parent;
    }

    @Override
    public String getPrefix() {
        if (this.getNodeKind() == 1) {
            String name = this.getDomNode().getNodeName();
            int colon = name.indexOf(58);
            if (colon < 0) {
                return "";
            }
            return name.substring(0, colon);
        }
        return "";
    }

    @Override
    public DominoNode getRoot() {
        return this.tree.getRootNode();
    }

    @Override
    public String getSystemId() {
        return this.tree.getSystemId();
    }

    @Override
    public TreeInfo getTreeInfo() {
        return this.tree;
    }

    @Override
    public NamespaceUri getNamespaceUri() {
        int fp = this.getFingerprint();
        return fp == -1 ? NamespaceUri.NULL : this.tree.getNamePool().getURI(fp);
    }

    @Override
    public boolean hasChildNodes() {
        int kind = this.getNodeKind();
        return (kind == 1 || kind == 9) && this.tree.depth[this.nodeNr + 1] > this.tree.depth[this.nodeNr];
    }

    public boolean hasAttributes() {
        return this.getNodeKind() == 1 && (this.tree.nameCode[this.nodeNr] & 0x2000000) != 0;
    }

    public boolean hasNamespaces() {
        return this.getNodeKind() == 1 && (this.tree.nameCode[this.nodeNr] & 0x4000000) != 0;
    }

    @Override
    public boolean hasFingerprint() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DominoNode && ((DominoNode)other).tree == this.tree && ((DominoNode)other).nodeNr == this.nodeNr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AxisIterator iterateAxis(int axisNumber, NodePredicate predicate) {
        if (predicate instanceof NodeTest) {
            NodeTest nodeTest = (NodeTest)predicate;
            int type = this.getNodeKind();
            switch (axisNumber) {
                case 0: {
                    return new AncestorIterator(this, nodeTest);
                }
                case 1: {
                    AncestorIterator ancestors = new AncestorIterator(this, nodeTest);
                    if (nodeTest.test(this)) {
                        return new PrependAxisIterator(this, ancestors);
                    }
                    return ancestors;
                }
                case 2: {
                    if (!this.hasAttributes()) {
                        return EmptyIterator.ofNodes();
                    }
                    Node element = this.getDomNode();
                    if (nodeTest instanceof NameTest) {
                        NamespaceUri uri = ((NameTest)nodeTest).getNamespaceURI();
                        String ns = uri.isEmpty() ? null : uri.toString();
                        String local = ((NameTest)nodeTest).getLocalPart();
                        Node node = this.getDomNode();
                        synchronized (node) {
                            Attr attr = (Attr)element.getAttributes().getNamedItemNS(ns, local);
                            if (attr == null) {
                                return EmptyIterator.ofNodes();
                            }
                            DominoAttr wrappedAttr = new DominoAttr(this.tree, this, attr);
                            return SingleNodeIterator.makeIterator(wrappedAttr);
                        }
                    }
                    Node uri = element;
                    synchronized (uri) {
                        ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
                        NamedNodeMap atts = element.getAttributes();
                        if (atts != null) {
                            int attsLen = atts.getLength();
                            for (int i = 0; i < attsLen; ++i) {
                                String name = atts.item(i).getNodeName();
                                if (name.startsWith("xmlns") && (name.length() == 5 || name.charAt(5) == ':')) continue;
                                list.add(new DominoAttr(this.tree, this, (Attr)atts.item(i)));
                            }
                        }
                        return new Navigator.AxisFilter(new NodeListIterator((List<NodeInfo>)list), nodeTest);
                    }
                }
                case 3: {
                    if (this.hasChildNodes()) {
                        return new SiblingIterator(this.tree, this, nodeTest, true);
                    }
                    return EmptyIterator.ofNodes();
                }
                case 4: {
                    if (type == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                        return this.tree.getAllElements(nodeTest.getFingerprint());
                    }
                    if (this.hasChildNodes()) {
                        return new DescendantIterator(this.tree, this, nodeTest);
                    }
                    return EmptyIterator.ofNodes();
                }
                case 5: {
                    if (this.hasChildNodes()) {
                        DescendantIterator descendants = new DescendantIterator(this.tree, this, nodeTest);
                        if (nodeTest.test(this)) {
                            return new PrependAxisIterator(this, descendants);
                        }
                        return descendants;
                    }
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                case 6: {
                    if (type == 2 || type == 13) {
                        return new FollowingIterator(this.tree, this.getParent(), nodeTest, true);
                    }
                    if (this.tree.depth[this.nodeNr] == 0) {
                        return EmptyIterator.ofNodes();
                    }
                    return new FollowingIterator(this.tree, this, nodeTest, false);
                }
                case 7: {
                    if (type == 2 || type == 13 || this.tree.depth[this.nodeNr] == 0) {
                        return EmptyIterator.ofNodes();
                    }
                    return new SiblingIterator(this.tree, this, nodeTest, false);
                }
                case 8: {
                    AxisIterator unfiltered;
                    if (type != 1) {
                        return EmptyIterator.ofNodes();
                    }
                    if (!this.hasNamespaces()) {
                        DominoNode parent = this.getParent();
                        if (parent.getNodeKind() == 1) {
                            unfiltered = parent.iterateAxis(axisNumber, nodeTest);
                        } else {
                            NamespaceBinding xml = NamespaceBinding.XML;
                            unfiltered = SingleNodeIterator.makeIterator(new NamespaceNode(this, xml, 0));
                        }
                    } else {
                        unfiltered = NamespaceNode.makeIterator(this, nodeTest);
                    }
                    return new Navigator.AxisFilter(unfiltered, nodeTest);
                }
                case 9: {
                    DominoNode parent = this.getParent();
                    return Navigator.filteredSingleton(parent, nodeTest);
                }
                case 10: {
                    if (type == 2 || type == 13) {
                        return new PrecedingIterator(this.tree, this.getParent(), nodeTest, false);
                    }
                    if (this.tree.depth[this.nodeNr] == 0) {
                        return EmptyIterator.ofNodes();
                    }
                    return new PrecedingIterator(this.tree, this, nodeTest, false);
                }
                case 11: {
                    if (type == 2 || type == 13 || this.tree.depth[this.nodeNr] == 0) {
                        return EmptyIterator.ofNodes();
                    }
                    return new PrecedingSiblingIterator(this.tree, this, nodeTest);
                }
                case 12: {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                case 13: {
                    if (type == 9) {
                        return EmptyIterator.ofNodes();
                    }
                    return new PrecedingIterator(this.tree, this, nodeTest, true);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + axisNumber);
        }
        return new Navigator.AxisFilter(this.iterateAxis(axisNumber, AnyNodeTest.getInstance()), predicate);
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getUnicodeStringValue());
            }
        }
        return StringValue.makeUntypedAtomic(this.getUnicodeStringValue());
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                if (this.hasChildNodes()) {
                    NodeList children1 = this.getDomNode().getChildNodes();
                    UnicodeBuilder sb1 = new UnicodeBuilder();
                    DOMNodeWrapper.expandStringValue(children1, sb1);
                    return sb1.toUnicodeString();
                }
                return EmptyUnicodeString.getInstance();
            }
            case 2: {
                return DominoNode.emptyIfNull(((Attr)this.getDomNode()).getValue());
            }
            case 3: {
                UnicodeString value = DominoNode.emptyIfNull(this.getDomNode().getNodeValue());
                if ((this.tree.nameCode[this.nodeNr] & 0x8000000) != 0) {
                    UnicodeBuilder buffer = new UnicodeBuilder();
                    buffer.accept(value);
                    Node textNode = this.getDomNode();
                    while ((textNode = textNode.getNextSibling()) != null) {
                        buffer.accept(DominoNode.emptyIfNull(textNode.getNodeValue()));
                    }
                    return buffer.toUnicodeString();
                }
                return value;
            }
            case 7: 
            case 8: {
                return DominoNode.emptyIfNull(this.getDomNode().getNodeValue());
            }
        }
        return EmptyUnicodeString.getInstance();
    }

    private static UnicodeString emptyIfNull(String s) {
        return s == null ? EmptyUnicodeString.getInstance() : StringView.of(s).tidy();
    }

    @Override
    public Location saveLocation() {
        return null;
    }

    @Override
    public void setSystemId(String systemId) {
    }

    @Override
    public Node getRealNode() {
        return this.getDomNode();
    }

    @Override
    public Node getUnderlyingNode() {
        return this.getDomNode();
    }
}

