/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.AttributeGroupReference;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.XSDAnyAttribute;
import com.saxonica.ee.schema.sdoc.XSDAssert;
import com.saxonica.ee.schema.sdoc.XSDAttribute;
import com.saxonica.ee.schema.sdoc.XSDAttributeGroup;
import com.saxonica.ee.schema.sdoc.XSDCompositor;
import com.saxonica.ee.schema.sdoc.XSDGroup;
import com.saxonica.ee.schema.sdoc.XSDOpenContent;
import com.saxonica.ee.schema.sdoc.XSDSimpleContent;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.SchemaException;

public class XSDExtension
extends SchemaElement {
    private UserComplexType complexType = null;
    private boolean isSimpleContent;
    private static final int[] state0terms = new int[]{586, 619, 582, 612, 578, 585, 580, 576, 584, 596};
    private static final int[] state0targets = new int[]{2, 2, 6, 4, 5, 1, 3, 2, 1, 2};
    private static final int[] state1terms = new int[]{584, 585, 580, 582};
    private static final int[] state1targets = new int[]{1, 1, 3, 6};
    private static final int[] state2terms = new int[]{584, 585, 580, 582};
    private static final int[] state2targets = new int[]{1, 1, 3, 6};
    private static final int[] state3terms = new int[]{582};
    private static final int[] state3targets = new int[]{6};
    private static final int[] state4terms = new int[]{584, 596, 586, 585, 576, 580, 619, 582};
    private static final int[] state4targets = new int[]{1, 2, 2, 1, 2, 3, 2, 6};
    private static final int[] state5terms = new int[]{586, 619, 582, 612, 585, 580, 576, 584, 596};
    private static final int[] state5targets = new int[]{2, 2, 6, 4, 1, 3, 2, 1, 2};
    private static final int[] state6terms = new int[]{582};
    private static final int[] state6targets = new int[]{6};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms, state4terms, state5terms, state6terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets, state4targets, state5targets, state6targets};

    @Override
    protected void prepareAttributes() throws SchemaException {
        int baseFingerprint;
        try {
            this.complexType = this.getContainingComplexType();
        }
        catch (SchemaException e) {
            e.setLocator(this);
            this.error(e);
            return;
        }
        this.isSimpleContent = this.getParent() instanceof XSDSimpleContent;
        this.complexType.setDerivationMethodName("extension");
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"base", "id"};
        this.allowAttributes(atts, allowed);
        String base = atts.getValue(NamespaceUri.NULL, "base");
        if (base != null) {
            try {
                baseFingerprint = this.getFingerprint(base, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
        } else {
            this.missingAttribute("base");
            return;
        }
        this.checkPermittedType(baseFingerprint, base, "a base type");
        TypeReference baseType = new TypeReference(baseFingerprint, this.complexType.getConfiguration(), this);
        this.complexType.setBaseTypeReference(baseType);
        this.processId();
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        this.checkContentModel(stateTerms, stateTargets, false);
        if (this.isSimpleContent) {
            for (NodeInfo nodeInfo : this.children()) {
                int fp = nodeInfo.getFingerprint();
                switch (fp) {
                    case 576: 
                    case 586: 
                    case 596: 
                    case 619: {
                        String name = nodeInfo.getLocalPart();
                        this.error((name.equals("all") ? "An" : "A") + ' ' + Err.wrap(name, 1) + " model group cannot appear in simple content");
                        return;
                    }
                    case 612: {
                        this.error("An <openContent> element cannot appear in simple content");
                        return;
                    }
                }
            }
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return true;
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        if (this.complexType == null) {
            return;
        }
        for (NodeInfo nodeInfo : this.children()) {
            switch (nodeInfo.getFingerprint()) {
                case 580: {
                    AttributeWildcard wildcard = ((XSDAnyAttribute)nodeInfo).getWildcard();
                    this.complexType.setAnyAttribute(wildcard);
                    break;
                }
                case 584: {
                    AttributeUse attrDecl = ((XSDAttribute)nodeInfo).getAttributeUse();
                    this.complexType.addAttributeUse(attrDecl);
                    break;
                }
                case 585: {
                    AttributeGroupReference attrGroupRef = ((XSDAttributeGroup)nodeInfo).getAttributeGroupReference();
                    this.complexType.addAttributeGroupReference(attrGroupRef);
                    break;
                }
                case 596: {
                    ModelGroupParticle modelGroup = ((XSDGroup)nodeInfo).getGroupReference();
                    this.complexType.setParticle(modelGroup);
                    break;
                }
                case 576: 
                case 586: 
                case 619: {
                    ModelGroupParticle group = ((XSDCompositor)nodeInfo).getModelGroupParticle();
                    this.complexType.setParticle(group);
                    break;
                }
                case 582: {
                    Assertion assertion = ((XSDAssert)nodeInfo).getAssertion();
                    this.complexType.addAssertion(assertion);
                    break;
                }
                case 578: {
                    break;
                }
                case 612: {
                    ElementWildcard ew = ((XSDOpenContent)nodeInfo).getElementWildcard();
                    Wildcard openContentWildcard = ew == null ? null : ew.getWildcard();
                    String openContentMode = ((XSDOpenContent)nodeInfo).getMode();
                    this.complexType.setOpenContentWildcard(openContentWildcard, openContentMode, true);
                    break;
                }
            }
        }
    }
}

