/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.om;

import com.saxonica.ee.stream.om.AttributeIterator;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import java.util.Objects;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodePredicate;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;

public class FleetingElementNode
extends FleetingParentNode {
    private NamespaceMap inScopeNamespaces;
    private AttributeMap attributeMap;

    public FleetingElementNode(NodeName name, SchemaType type) {
        this.setNodeKind(1);
        this.setNodeName(name);
        this.setTypeAnnotation(type);
    }

    public FleetingElementNode(NodeName name, SchemaType type, AttributeMap attributes, NamespaceMap namespaces) {
        this.setNodeKind(1);
        this.setNodeName(name);
        this.setTypeAnnotation(type);
        this.setAttributes(attributes);
        this.setNamespaceMap(namespaces);
    }

    public void setNamespaceMap(NamespaceMap namespaces) {
        this.inScopeNamespaces = namespaces;
    }

    @Override
    public NamespaceMap getAllNamespaces() {
        return this.inScopeNamespaces;
    }

    public void setAttributes(AttributeMap attributes) {
        this.attributeMap = attributes;
    }

    @Override
    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        throw new UnsupportedOperationException("copy() is not supported for streamed " + Err.wrap(this.getDisplayName(), 1) + " element node");
    }

    @Override
    public AxisIterator iterateAxis(int axisNumber, NodePredicate nodeTest) {
        switch (axisNumber) {
            case 2: {
                if (this.attributeMap.size() == 0) {
                    return EmptyIterator.ofNodes();
                }
                if (nodeTest instanceof NameTest) {
                    AttributeInfo att = this.attributeMap.getByFingerprint(((NameTest)nodeTest).getFingerprint(), this.getConfiguration().getNamePool());
                    return att == null ? EmptyIterator.ofNodes() : SingleNodeIterator.makeIterator(this.makeAttributeNode(att));
                }
                AttributeIterator base = new AttributeIterator(this, this.attributeMap);
                return new Navigator.AxisFilter(base, nodeTest);
            }
            case 8: {
                return NamespaceNode.makeIterator(this, nodeTest);
            }
        }
        return super.iterateAxis(axisNumber, nodeTest);
    }

    public FleetingNode makeAttributeNode(AttributeInfo attInfo) {
        Objects.requireNonNull(attInfo);
        FleetingNode attr = new FleetingNode();
        attr.setParent(this);
        attr.setNodeKind(2);
        attr.setNodeName(attInfo.getNodeName());
        attr.setTypeAnnotation(attInfo.getType());
        attr.setStringValue(StringView.tidy(attInfo.getValue()));
        return attr;
    }

    public AttributeMap getAttributes() {
        return this.attributeMap;
    }

    @Override
    public NamespaceMap getInScopeNamespaces() {
        return this.inScopeNamespaces;
    }

    @Override
    public String getAttributeValue(NamespaceUri uri, String local) {
        return this.attributeMap.getValue(uri, local);
    }

    public int getAttributeIndex(NamespaceUri uri, String local) {
        int i = 0;
        for (AttributeInfo att : this.attributeMap) {
            NodeName nn = att.getNodeName();
            if (nn.hasURI(uri) && nn.getLocalPart().equals(local)) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public int compareAttributeOrder(NodeName one, NodeName two) {
        if (one.equals(two)) {
            return 0;
        }
        for (AttributeInfo att : this.attributeMap) {
            NodeName nn = att.getNodeName();
            if (nn.equals(one)) {
                return -1;
            }
            if (!nn.equals(two)) continue;
            return 1;
        }
        throw new IllegalStateException("Attribute not found in attribute list");
    }

    public int getNamespaceNodeIndex(String prefix) {
        NodeInfo node;
        int index = 0;
        AxisIterator iter = this.iterateAxis(8);
        while ((node = iter.next()) != null) {
            ++index;
            if (!node.getLocalPart().equals(prefix)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public void notify(Receiver out) throws XPathException {
        out.startElement(this.getNodeName(), this.getSchemaType(), this.getAttributes(), this.getAllNamespaces(), this, 0);
    }
}

