/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import com.saxonica.ee.stream.ManualGroupIterator;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.SequenceExtent;

public abstract class GroupMatchingIterator
implements LookaheadIterator,
LastPositionFinder,
GroupIterator {
    protected PullEvaluator select;
    protected FocusIterator population;
    protected Pattern pattern;
    protected XPathContext baseContext;
    protected XPathContext runningContext;
    protected List<Item> currentMembers;
    protected Item nextItem;
    protected Item current = null;
    protected int position = 0;

    protected abstract void advance() throws XPathException;

    @Override
    public AtomicSequence getCurrentGroupingKey() {
        return null;
    }

    @Override
    public GroundedValue currentGroup() throws XPathException {
        return SequenceExtent.makeSequenceExtent(this.currentMembers);
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public Item next() {
        try {
            if (this.nextItem != null) {
                this.current = this.nextItem;
                ++this.position;
                this.advance();
                return this.current;
            }
            this.current = null;
            this.position = -1;
            return null;
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    @Override
    public void close() {
        this.population.close();
    }

    @Override
    public ManualGroupIterator getSnapShot(XPathContext context) {
        ManualGroupIterator iter = new ManualGroupIterator(this.current, this.position);
        iter.setCurrentGroup(SequenceExtent.makeSequenceExtent(this.currentMembers));
        iter.setLengthFinder(CSharp.methodRef(this.runningContext::getLast));
        return iter;
    }
}

