/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom2;

import java.util.Stack;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.option.jdom2.JDOM2DocumentWrapper;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;
import org.jdom2.Attribute;
import org.jdom2.AttributeType;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;

public class JDOM2Writer
extends Builder {
    private Document document;
    private final Stack<Parent> ancestors = new Stack();
    private boolean implicitDocumentNode = false;
    private final StringBuilder textBuffer = new StringBuilder(256);
    private final Stack<NamespaceMap> nsStack = new Stack();

    public JDOM2Writer(PipelineConfiguration pipe) {
        super(pipe);
        this.nsStack.push(NamespaceMap.emptyMap());
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.document = new Document();
        this.document.setBaseURI(this.systemId);
        this.ancestors.push((Parent)this.document);
        this.textBuffer.setLength(0);
    }

    @Override
    public void endDocument() throws XPathException {
        this.ancestors.pop();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.flush();
        String local = elemName.getLocalPart();
        NamespaceUri uri = elemName.getNamespaceUri();
        String prefix = elemName.getPrefix();
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        Element element = new Element(local, prefix, uri.toString());
        if (this.ancestors.size() == 1) {
            this.document.setRootElement(element);
        } else {
            this.ancestors.peek().addContent((Content)element);
        }
        this.ancestors.push((Parent)element);
        NamespaceMap parentMap = this.nsStack.peek();
        if (namespaces != parentMap) {
            NamespaceBinding[] declarations;
            for (NamespaceBinding ns : declarations = namespaces.getDifferences(parentMap, false)) {
                this.namespace(element, ns);
            }
        }
        this.nsStack.push(namespaces);
        for (AttributeInfo att : attributes) {
            boolean isXmlId;
            NodeName nameCode = att.getNodeName();
            String attlocal = nameCode.getLocalPart();
            NamespaceUri atturi = nameCode.getNamespaceUri();
            String attprefix = nameCode.getPrefix();
            String value = att.getValue();
            Namespace ns = attprefix.isEmpty() ? Namespace.getNamespace((String)atturi.toString()) : Namespace.getNamespace((String)attprefix, (String)atturi.toString());
            boolean bl = isXmlId = atturi.equals(NamespaceUri.XML) && attlocal.equals("id");
            if (isXmlId) {
                value = Whitespace.trim(value);
            }
            Attribute attr = new Attribute(attlocal, value, ns);
            if (isXmlId) {
                attr.setAttributeType(AttributeType.ID);
            }
            element.getAttributes().add(attr);
        }
    }

    private void namespace(Element element, NamespaceBinding namespaceBinding) throws XPathException {
        String prefix = namespaceBinding.getPrefix();
        NamespaceUri uri = namespaceBinding.getNamespaceUri();
        if (uri.isEmpty() && prefix.length() != 0) {
            return;
        }
        Namespace ns = prefix.isEmpty() ? Namespace.getNamespace((String)uri.toString()) : Namespace.getNamespace((String)prefix, (String)uri.toString());
        element.addNamespaceDeclaration(ns);
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.ancestors.pop();
        this.nsStack.pop();
        Parent parent = this.ancestors.peek();
        if (parent == this.document && this.implicitDocumentNode) {
            this.endDocument();
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            Text text = new Text(this.textBuffer.toString());
            this.ancestors.peek().addContent((Content)text);
            this.textBuffer.setLength(0);
        }
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        this.flush();
        ProcessingInstruction pi = new ProcessingInstruction(target, data.toString());
        this.ancestors.peek().addContent((Content)pi);
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.flush();
        Comment comment = new Comment(chars.toString());
        this.ancestors.peek().addContent((Content)comment);
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        return new JDOM2DocumentWrapper(this.document, this.config).getRootNode();
    }
}

