/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.KrillQuery;
import de.ids_mannheim.korap.query.wrap.SpanAlterQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanClassQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanElementQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanFocusQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanRegexQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanRepetitionQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanSegmentQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanSequenceQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanWildcardQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanWithinQueryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilder {
    private String field;
    private static final Logger log = LoggerFactory.getLogger(KrillQuery.class);
    public static final boolean DEBUG = false;
    public static final byte OVERLAP = 0;
    public static final byte REAL_OVERLAP = 2;
    public static final byte WITHIN = 4;
    public static final byte REAL_WITHIN = 6;
    public static final byte ENDSWITH = 8;
    public static final byte STARTSWITH = 10;
    public static final byte MATCH = 12;

    public QueryBuilder(String field) {
        this.field = field;
    }

    public SpanRegexQueryWrapper re(String re) {
        return new SpanRegexQueryWrapper(this.field, re, 65535, false);
    }

    public SpanRegexQueryWrapper re(String re, int flags) {
        return new SpanRegexQueryWrapper(this.field, re, flags, false);
    }

    public SpanRegexQueryWrapper re(String re, int flags, boolean caseinsensitive) {
        return new SpanRegexQueryWrapper(this.field, re, flags, caseinsensitive);
    }

    public SpanRegexQueryWrapper re(String re, boolean caseinsensitive) {
        return new SpanRegexQueryWrapper(this.field, re, 65535, caseinsensitive);
    }

    public SpanWildcardQueryWrapper wc(String wc) {
        return new SpanWildcardQueryWrapper(this.field, wc, false);
    }

    public SpanWildcardQueryWrapper wc(String wc, boolean caseinsensitive) {
        return new SpanWildcardQueryWrapper(this.field, wc, caseinsensitive);
    }

    public SpanSegmentQueryWrapper seg() {
        return new SpanSegmentQueryWrapper(this.field);
    }

    public SpanSegmentQueryWrapper seg(SpanRegexQueryWrapper ... terms) {
        SpanSegmentQueryWrapper ssq = new SpanSegmentQueryWrapper(this.field);
        for (SpanRegexQueryWrapper t : terms) {
            ssq.with(t);
        }
        return ssq;
    }

    public SpanSegmentQueryWrapper seg(SpanAlterQueryWrapper ... terms) {
        SpanSegmentQueryWrapper ssq = new SpanSegmentQueryWrapper(this.field);
        for (SpanAlterQueryWrapper t : terms) {
            ssq.with(t);
        }
        return ssq;
    }

    public SpanSegmentQueryWrapper seg(String ... terms) {
        SpanSegmentQueryWrapper ssq = new SpanSegmentQueryWrapper(this.field);
        for (String t : terms) {
            ssq.with(t);
        }
        return ssq;
    }

    public SpanRepetitionQueryWrapper empty() {
        return new SpanRepetitionQueryWrapper();
    }

    public SpanAlterQueryWrapper or(SpanQueryWrapper ... terms) {
        SpanAlterQueryWrapper ssaq = new SpanAlterQueryWrapper(this.field);
        for (SpanQueryWrapper t : terms) {
            ssaq.or(t);
        }
        return ssaq;
    }

    public SpanAlterQueryWrapper or(String ... terms) {
        SpanAlterQueryWrapper ssaq = new SpanAlterQueryWrapper(this.field);
        for (String t : terms) {
            ssaq.or(t);
        }
        return ssaq;
    }

    public SpanSequenceQueryWrapper seq() {
        return new SpanSequenceQueryWrapper(this.field);
    }

    public SpanSequenceQueryWrapper seq(SpanQueryWrapper ... terms) {
        SpanSequenceQueryWrapper sssq = new SpanSequenceQueryWrapper(this.field);
        for (SpanQueryWrapper t : terms) {
            sssq.append(t);
        }
        return sssq;
    }

    public SpanSequenceQueryWrapper seq(SpanRegexQueryWrapper re) {
        return new SpanSequenceQueryWrapper(this.field, re);
    }

    public SpanSequenceQueryWrapper seq(Object ... terms) {
        SpanSequenceQueryWrapper ssq = new SpanSequenceQueryWrapper(this.field);
        for (Object t : terms) {
            if (t instanceof SpanQueryWrapper) {
                ssq.append((SpanQueryWrapper)t);
                continue;
            }
            if (t instanceof SpanRegexQueryWrapper) {
                ssq.append((SpanRegexQueryWrapper)t);
                continue;
            }
            log.error("{} is not an acceptable parameter for seq()", (Object)t.getClass());
            return ssq;
        }
        return ssq;
    }

    public SpanElementQueryWrapper tag(String element) {
        return new SpanElementQueryWrapper(this.field, element);
    }

    public SpanWithinQueryWrapper contains(SpanQueryWrapper element, SpanQueryWrapper embedded) {
        return new SpanWithinQueryWrapper(element, embedded, 4);
    }

    public SpanWithinQueryWrapper startswith(SpanQueryWrapper element, SpanQueryWrapper embedded) {
        return new SpanWithinQueryWrapper(element, embedded, 10);
    }

    public SpanWithinQueryWrapper endswith(SpanQueryWrapper element, SpanQueryWrapper embedded) {
        return new SpanWithinQueryWrapper(element, embedded, 8);
    }

    public SpanWithinQueryWrapper overlaps(SpanQueryWrapper element, SpanQueryWrapper embedded) {
        return new SpanWithinQueryWrapper(element, embedded, 0);
    }

    public SpanWithinQueryWrapper matches(SpanQueryWrapper element, SpanQueryWrapper embedded) {
        return new SpanWithinQueryWrapper(element, embedded, 12);
    }

    public SpanClassQueryWrapper nr(byte number, SpanQueryWrapper element) {
        return new SpanClassQueryWrapper(element, number);
    }

    public SpanClassQueryWrapper nr(int number, SpanQueryWrapper element) {
        return new SpanClassQueryWrapper(element, number);
    }

    public SpanClassQueryWrapper nr(short number, SpanQueryWrapper element) {
        return new SpanClassQueryWrapper(element, number);
    }

    public SpanClassQueryWrapper nr(SpanQueryWrapper element) {
        return new SpanClassQueryWrapper(element);
    }

    public SpanFocusQueryWrapper focus(byte number, SpanQueryWrapper element) {
        return new SpanFocusQueryWrapper(element, number);
    }

    public SpanFocusQueryWrapper focus(int number, SpanQueryWrapper element) {
        return new SpanFocusQueryWrapper(element, number);
    }

    public SpanFocusQueryWrapper focus(short number, SpanQueryWrapper element) {
        return new SpanFocusQueryWrapper(element, number);
    }

    public SpanFocusQueryWrapper focus(SpanQueryWrapper element) {
        return new SpanFocusQueryWrapper(element);
    }

    public SpanRepetitionQueryWrapper repeat(SpanQueryWrapper element, int exact) {
        return new SpanRepetitionQueryWrapper(element, exact);
    }

    public SpanRepetitionQueryWrapper repeat(SpanQueryWrapper element, int min, int max) {
        return new SpanRepetitionQueryWrapper(element, min, max);
    }

    public SpanRepetitionQueryWrapper opt(SpanQueryWrapper element) {
        return new SpanRepetitionQueryWrapper(element, 0, 1);
    }
}

