/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import marmot.core.ArrayFloatFeatureVector;
import marmot.core.DenseArrayFloatFeatureVector;
import marmot.core.FloatFeatureVector;
import marmot.morph.MorphDictionaryOptions;
import marmot.util.Converter;
import marmot.util.LineIterator;
import marmot.util.SymbolTable;

public class FloatHashDictionary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, FloatFeatureVector> index_map_;
    private SymbolTable<String> column_table_;
    private MorphDictionaryOptions options_;

    protected void readSparseVector(LineIterator iterator2) {
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (line.isEmpty()) continue;
            String form = (String)line.get(0);
            LinkedList<Integer> indexes = new LinkedList<Integer>();
            LinkedList<Double> values2 = new LinkedList<Double>();
            for (int i = 1; i < line.size(); ++i) {
                String pair_string = (String)line.get(i);
                String[] key_value = pair_string.split(":");
                Double value = null;
                if (key_value.length == 2) {
                    try {
                        value = Double.parseDouble(key_value[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (value == null) {
                    System.err.println("Skipping pair string: " + pair_string);
                    continue;
                }
                String key = key_value[0];
                int index = this.column_table_.toIndex(key, true);
                assert (index >= 0);
                indexes.add(index);
                values2.add(value);
            }
            ArrayFloatFeatureVector vector = new ArrayFloatFeatureVector(Converter.toIntArray(indexes), Converter.toDoubleArray(values2), 0);
            this.index_map_.put(form, vector);
        }
    }

    public void readDenseVector(LineIterator iterator2) {
        int dim = -1;
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (dim == -1 && line.size() == 2) {
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.info(String.format("Skipping possible file header: %s", line));
                continue;
            }
            if (line.isEmpty()) continue;
            if (dim < 0) {
                dim = line.size() - 1;
                for (int i = 0; i < dim; ++i) {
                    this.column_table_.toIndex(Integer.toString(i), true);
                }
            }
            String form = (String)line.get(0);
            if (dim != line.size() - 1) {
                System.err.format("Dimension was expected to be %d, but is %d\n Line : %s\n", dim, line.size() - 1, line.toString());
                System.exit(1);
            }
            double[] weights = new double[dim];
            for (int i = 1; i < dim + 1; ++i) {
                Double value = Double.parseDouble((String)line.get(i));
                weights[i - 1] = value;
            }
            DenseArrayFloatFeatureVector vector = new DenseArrayFloatFeatureVector(weights);
            this.index_map_.put(form, vector);
        }
    }

    public void init(MorphDictionaryOptions options) {
        this.options_ = options;
        LineIterator iterator2 = new LineIterator(this.options_.getFilename());
        this.column_table_ = new SymbolTable();
        this.index_map_ = new HashMap<String, FloatFeatureVector>();
        if (this.options_.getDense()) {
            this.readDenseVector(iterator2);
        } else {
            this.readSparseVector(iterator2);
            for (Map.Entry<String, FloatFeatureVector> entry : this.index_map_.entrySet()) {
                FloatFeatureVector floatFeatureVector = entry.getValue();
                if (!(floatFeatureVector instanceof ArrayFloatFeatureVector)) continue;
                ArrayFloatFeatureVector vec = (ArrayFloatFeatureVector)floatFeatureVector;
                if (this.column_table_.size() == vec.getWeights().length) {
                    entry.setValue(new DenseArrayFloatFeatureVector(vec.getWeights()));
                    continue;
                }
                double[] weights = new double[this.column_table_.size()];
                for (int index = 0; index < vec.getWeights().length; ++index) {
                    weights[vec.getFeatures()[index]] = vec.getWeights()[index];
                }
            }
        }
    }

    public FloatFeatureVector getVector(String form) {
        FloatFeatureVector v = this.index_map_.get(form);
        return v;
    }

    public int getDimension() {
        return this.column_table_.size();
    }

    public int numEntries() {
        return this.index_map_.size();
    }
}

