/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.CopyModifyExpression;
import com.saxonica.ee.update.DeleteExpression;
import com.saxonica.ee.update.InsertExpression;
import com.saxonica.ee.update.RenameExpression;
import com.saxonica.ee.update.ReplaceNodeExpression;
import com.saxonica.ee.update.ReplaceValueExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class UpdateParser {
    private UpdateParser() {
    }

    public static Expression parseTransformExpression(XPathParser p) throws XPathException {
        int i;
        CopyModifyExpression copyExp;
        Tokenizer t = p.getTokenizer();
        int offset = t.currentTokenStartOffset;
        ArrayList<CopyClause> clauseList = new ArrayList<CopyClause>(4);
        while (t.currentToken == 219) {
            UpdateParser.parseCopyClause(p, clauseList);
        }
        int modifyOffset = t.currentTokenStartOffset;
        p.expect(68);
        t.setState(0);
        p.nextToken();
        Expression updateExp = p.parseExprSingle();
        updateExp = p.makeTracer(updateExp, null);
        int returnOffset = t.currentTokenStartOffset;
        p.expect(25);
        t.setState(0);
        p.nextToken();
        Expression returnExp = p.parseExprSingle();
        returnExp = p.makeTracer(returnExp, null);
        int revalidationMode = ((QueryModule)p.getStaticContext()).getRevalidationMode();
        Expression e = copyExp = new CopyModifyExpression(updateExp, returnExp, revalidationMode);
        ArrayList<Expression> copyBindings = new ArrayList<Expression>(clauseList.size());
        for (i = clauseList.size() - 1; i >= 0; --i) {
            CopyClause clause = (CopyClause)clauseList.get(i);
            LetExpression let = clause.binding;
            LocalVariableReference var = new LocalVariableReference(let);
            copyBindings.add(var);
            let.setAction(e);
            e = let;
        }
        copyExp.setCopyBindings(Block.makeBlock(copyBindings));
        for (i = clauseList.size() - 1; i >= 0; --i) {
            p.undeclareRangeVariable();
        }
        p.setLocation(e, offset);
        return p.makeTracer(e, null);
    }

    private static void parseCopyClause(XPathParser p, List<CopyClause> clauseList) throws XPathException {
        boolean first = true;
        Tokenizer t = p.getTokenizer();
        do {
            CopyClause clause = new CopyClause();
            if (first) {
                clause.offset = t.currentTokenStartOffset;
            }
            clauseList.add(clause);
            p.nextToken();
            if (first) {
                first = false;
            } else {
                clause.offset = t.currentTokenStartOffset;
            }
            p.expect(21);
            p.nextToken();
            p.expect(201);
            String var = t.currentTokenValue;
            LetExpression v = new LetExpression();
            StructuredQName varQName = p.makeStructuredQName(var, NamespaceUri.NULL);
            v.setRequiredType(SequenceType.SINGLE_NODE);
            v.setVariableQName(varQName);
            clause.binding = v;
            p.nextToken();
            p.expect(58);
            p.nextToken();
            Expression rhs = p.parseExprSingle();
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(10, "copyModify", 0, "XUTY0013");
            rhs = new ItemChecker(rhs, AnyNodeTest.getInstance(), role);
            rhs = CardinalityChecker.makeCardinalityChecker(rhs, 16384, role);
            boolean preserve = ((QueryModule)p.getStaticContext()).isPreserveNamespaces();
            CopyOf copy = new CopyOf(rhs, preserve, 4, null, true);
            copy.setCopyForUpdate(true);
            v.setSequence(copy);
            p.declareRangeVariable(v);
        } while (t.currentToken == 7);
    }

    public static Expression parseInsertExpression(XPathParser p) throws XPathException {
        int op;
        Tokenizer t = p.getTokenizer();
        int offset = t.currentTokenStartOffset;
        p.nextToken();
        Expression source = p.parseExprSingle();
        int position = op = t.currentToken;
        if (op == 71) {
            p.nextToken();
            op = t.currentToken;
            if (op == 131 || op == 132) {
                position = op;
            } else {
                p.grumble("Expected 'as first into' or 'as last into'");
            }
        } else if (op == 133 || op == 134 || op == 135) {
            position = op;
        } else {
            p.grumble("insert position must be one of: before | after | as first into | as last into | into");
        }
        p.nextToken();
        Expression target = p.parseExprSingle();
        QueryModule env = (QueryModule)p.getStaticContext();
        int constructionMode = env.getConstructionMode();
        boolean inherit = env.isInheritNamespaces();
        boolean preserve = env.isPreserveNamespaces();
        InsertExpression e = new InsertExpression(source, target, position, constructionMode, inherit, preserve);
        return p.makeTracer(e, null);
    }

    public static Expression parseDeleteExpression(XPathParser p) throws XPathException {
        int offset = p.getTokenizer().currentTokenStartOffset;
        p.nextToken();
        Expression target = p.parseExprSingle();
        DeleteExpression e = new DeleteExpression(target);
        return p.makeTracer(e, null);
    }

    public static Expression parseReplaceNodeExpression(XPathParser p) throws XPathException {
        int offset = p.getTokenizer().currentTokenStartOffset;
        p.nextToken();
        Expression target = p.parseExprSingle();
        p.expect(136);
        p.nextToken();
        Expression replacement = p.parseExprSingle();
        QueryModule env = (QueryModule)p.getStaticContext();
        ReplaceNodeExpression e = new ReplaceNodeExpression(target, replacement, env.getConstructionMode(), env.isInheritNamespaces());
        return p.makeTracer(e, null);
    }

    public static Expression parseReplaceValueExpression(XPathParser p) throws XPathException {
        int offset = p.getTokenizer().currentTokenStartOffset;
        p.nextToken();
        Expression target = p.parseExprSingle();
        p.expect(136);
        p.nextToken();
        Expression replacement = p.parseExprSingle();
        ReplaceValueExpression e = new ReplaceValueExpression(target, replacement);
        return p.makeTracer(e, null);
    }

    public static Expression parseRenameExpression(XPathParser p) throws XPathException {
        int offset = p.getTokenizer().currentTokenStartOffset;
        QueryModule env = (QueryModule)p.getStaticContext();
        p.nextToken();
        Expression target = p.parseExprSingle();
        p.expect(71);
        p.nextToken();
        Expression newName = p.parseExprSingle();
        boolean inherit = env.isInheritNamespaces();
        RenameExpression e = new RenameExpression(target, newName, env.getNamespaceResolver(), env.getDefaultElementNamespace(), inherit);
        return p.makeTracer(e, null);
    }

    private static class CopyClause {
        public LetExpression binding;
        public int offset;

        private CopyClause() {
        }
    }
}

