/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.fsa;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.fsa.Edge;
import com.saxonica.ee.schema.fsa.FiniteStateMachine;
import com.saxonica.ee.schema.fsa.State;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.ConcatenatingIterable;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.z.IntHashMap;

public abstract class AutomatonState
implements State {
    int stateNumber;
    private Iterable<Edge> specificTransitions = null;
    protected Edge[] wildcardEdges;
    private Edge maxTransition;
    private boolean _isFinalState = false;
    private int min = -1;
    private int max = -1;
    public static final Edge[] EMPTY_EDGE_ARRAY = new Edge[0];

    public AutomatonState(FiniteStateMachine machine) {
        machine.allocateStateNumber(this);
    }

    @Override
    public boolean isFinalState() {
        return this._isFinalState && this.min < 1;
    }

    public boolean isConditionallyFinalState() {
        return this._isFinalState;
    }

    public void setFinalState(boolean finalState) {
        this._isFinalState = finalState;
    }

    public int getStateNumber() {
        return this.stateNumber;
    }

    public void addSpecificTransition(Edge edge, SchemaCompiler compiler) throws SchemaException {
        ArrayList<Edge> list;
        ElementDecl decl = (ElementDecl)edge.getTerm();
        int key = decl.getFingerprint();
        Edge existing = this.getSpecificTransition(key);
        if (existing != null) {
            if (existing.getTerm() == decl) {
                if (existing.getParticle() != null && edge.getParticle() != null && existing.getParticle() != edge.getParticle()) {
                    String two;
                    String message = "Ambiguous content model: element particle " + Err.wrap(decl.getDisplayName(), 1) + " appears in more than one place in the content model";
                    String one = this.termParticleMessage(decl, existing.getParticle());
                    if (!one.equals(two = this.termParticleMessage(decl, edge.getParticle()))) {
                        message = message + ", once " + one + ", and once " + two;
                    }
                    throw new SchemaException(message);
                }
            } else {
                throw new SchemaException("Ambiguous content model, element " + Err.wrap(decl.getDisplayName(), 1) + " appears more than once");
            }
        }
        if (this.wildcardEdges != null && compiler.getLanguageVersion() == 10) {
            NamespaceUri uri = decl.getTargetNamespace();
            for (Edge wedge : this.wildcardEdges) {
                if (!((Wildcard)wedge.getTerm()).matches(uri)) continue;
                throw new SchemaException("Ambiguous content model, element " + Err.wrap(decl.getDisplayName(), 1) + " appears in its own right, and also matches an <xs:any> wildcard");
            }
        }
        if (this.specificTransitions == null) {
            this.specificTransitions = edge;
        } else if (this.specificTransitions instanceof Edge) {
            list = new ArrayList<Edge>(4);
            list.add((Edge)this.specificTransitions);
            list.add(edge);
            this.specificTransitions = list;
        } else {
            list = (ArrayList<Edge>)this.specificTransitions;
            list.add(edge);
        }
    }

    private String termParticleMessage(ElementDecl term, Particle particle) {
        try {
            if (((ElementDecl)particle.getTerm()).getFingerprint() == term.getFingerprint()) {
                return "in its own right";
            }
            return "as a member of the substitution group of element " + Err.wrap(((ElementDecl)particle.getTerm()).getDisplayName(), 1);
        }
        catch (MissingComponentException e) {
            return "indeterminably (" + e.getMessage() + ")";
        }
    }

    public void addWildcardTransition(SchemaCompiler compiler, Edge transition) throws SchemaException {
        if (this.wildcardEdges == null) {
            this.wildcardEdges = EMPTY_EDGE_ARRAY;
        } else {
            Wildcard thiscard = (Wildcard)transition.getTerm();
            for (Edge other : this.wildcardEdges) {
                if (!thiscard.overlaps((Wildcard)other.getTerm())) continue;
                throw new SchemaException("Ambiguous content model, there are two <xs:any> wildcards that match overlapping sets of namespaces");
            }
        }
        Wildcard transitionWildcard = (Wildcard)transition.getTerm();
        if (this.specificTransitions != null && compiler.getLanguageVersion() == 10) {
            for (Edge other : this.iterateSpecificTransitions()) {
                if (!transitionWildcard.matches(((ElementDecl)other.getTerm()).getTargetNamespace())) continue;
                throw new SchemaException("Ambiguous content model, element " + Err.wrap(((ElementDecl)other.getTerm()).getDisplayName(), 1) + " appears in its own right, and also matches an <xs:any> wildcard");
            }
        }
        this.wildcardEdges = Arrays.copyOf(this.wildcardEdges, this.wildcardEdges.length + 1);
        this.wildcardEdges[this.wildcardEdges.length - 1] = transition;
    }

    public void setLimits(int min, int max) {
        this.min = min;
        this.max = max;
    }

    int getMinOccurs() {
        return this.min;
    }

    int getMaxOccurs() {
        return this.max;
    }

    public boolean requiresCounter() {
        return this.min != -1;
    }

    @Override
    public Edge getTransition(int token, UserComplexType type) {
        Edge sedge = this.getSpecificTransition(token);
        if (sedge != null) {
            return sedge;
        }
        EnterpriseConfiguration config = type.getConfiguration();
        if (this.wildcardEdges != null && this.wildcardEdges.length > 0) {
            CodedName name = new CodedName(token, "", config.getNamePool());
            for (Edge wedge : this.wildcardEdges) {
                if (!((Wildcard)wedge.getTerm()).matches(name, true, (Configuration)config, type)) continue;
                return wedge;
            }
        }
        return null;
    }

    private Edge getSpecificTransition(int token) {
        if (this.specificTransitions != null) {
            for (Edge edge : this.specificTransitions) {
                if (((ElementDecl)edge.getTerm()).getFingerprint() != token) continue;
                return edge;
            }
        }
        return null;
    }

    Edge getEdge(Term t) {
        if (t instanceof ElementDecl && this.specificTransitions != null) {
            Edge e = this.getSpecificTransition(((ElementDecl)t).getFingerprint());
            if (e != null && e.getTerm() == t) {
                return e;
            }
            return null;
        }
        if (t instanceof Wildcard && this.wildcardEdges != null) {
            for (Edge wildcardEdge : this.wildcardEdges) {
                if (wildcardEdge.getTerm() != t) continue;
                return wildcardEdge;
            }
        }
        return null;
    }

    void addEdge(SchemaCompiler compiler, Term t, Particle p, AutomatonState s) throws SchemaException {
        Edge e = new Edge();
        e.setTerm(t);
        e.setParticle(p);
        e.setTargetState(s);
        if (t instanceof ElementDecl) {
            this.addSpecificTransition(e, compiler);
        } else if (t instanceof Wildcard) {
            this.addWildcardTransition(compiler, e);
        } else if (t instanceof Edge.MaxOccursTerm) {
            this.setMaxTransition(e);
        } else {
            throw new IllegalArgumentException("Term must be an ElementDecl or Wildcard");
        }
    }

    @Override
    public String listAllowedElements() {
        ArrayList<String> allowed = new ArrayList<String>(10);
        this.getAllowedElements(allowed);
        if (allowed.isEmpty()) {
            return "No further elements are allowed at this position";
        }
        StringBuilder sb = new StringBuilder(allowed.size() * 30);
        sb.append("Expected");
        if (allowed.size() > 1) {
            sb.append(" one of");
        }
        sb.append(": ");
        Iterator iter = allowed.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            sb.append(s);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private void getAllowedElements(List<String> list) {
        if (this.specificTransitions != null) {
            for (Edge edge : this.iterateSpecificTransitions()) {
                ElementDecl decl = (ElementDecl)edge.getTerm();
                String name = decl.getComponentName().getClarkName();
                list.add(name);
            }
        }
        if (this.wildcardEdges != null) {
            for (Edge wildcardEdge : this.wildcardEdges) {
                Wildcard w = (Wildcard)wildcardEdge.getTerm();
                list.add(w.toString());
            }
        }
    }

    private Iterable<Edge> iterateSpecificTransitions() {
        if (this.specificTransitions == null) {
            return Collections.emptyList();
        }
        if (this.specificTransitions instanceof Edge) {
            return this.specificTransitions;
        }
        if (this.specificTransitionsIsList()) {
            return (List)this.specificTransitions;
        }
        return ((IntHashMap)((Object)this.specificTransitions)).valueSet();
    }

    private boolean specificTransitionsIsList() {
        return this.specificTransitions instanceof List;
    }

    @Override
    public Edge[] getWildcardEdges() {
        return this.wildcardEdges == null ? EMPTY_EDGE_ARRAY : this.wildcardEdges;
    }

    @Override
    public Iterable<Edge> getEdges() {
        if (this.specificTransitions == null) {
            if (this.wildcardEdges == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.wildcardEdges);
        }
        if (this.wildcardEdges == null) {
            return this.iterateSpecificTransitions();
        }
        return new ConcatenatingIterable<Edge>(this.iterateSpecificTransitions(), Arrays.asList(this.wildcardEdges));
    }

    public void display(HashMap<AutomatonState, Integer> map) {
        if (map.isEmpty()) {
            System.err.println("====== FINITE STATE MACHINE ======");
        }
        int key = map.size();
        map.put(this, key);
        for (Edge edge : this.getEdges()) {
            String symbol;
            if (edge.getTerm() instanceof ElementDecl) {
                ElementDecl decl = (ElementDecl)edge.getTerm();
                symbol = decl.getDisplayName();
            } else {
                Wildcard card = (Wildcard)edge.getTerm();
                symbol = card.toString();
            }
            AutomatonState target = edge.getTargetState();
            int endKey = map.getOrDefault(target, Integer.MIN_VALUE);
            if (endKey == Integer.MIN_VALUE) {
                endKey = map.size();
                System.err.println(key + " " + symbol + " -> " + endKey + AutomatonState.finalMarker(target));
                target.display(map);
                continue;
            }
            System.err.println(key + " " + symbol + " -> " + endKey + AutomatonState.finalMarker(target));
        }
    }

    private static String finalMarker(AutomatonState state) {
        String finalFlag = "";
        if (state.isFinalState()) {
            finalFlag = "(F)";
        } else if (state.isConditionallyFinalState()) {
            finalFlag = "(F?)";
        }
        return finalFlag;
    }

    public void displayState(Logger err) {
        err.info("State " + this.stateNumber + AutomatonState.finalMarker(this));
        this.displayLambdaTransitions();
        for (Edge edge : this.getEdges()) {
            String symbol;
            if (edge.getTerm() instanceof ElementDecl) {
                ElementDecl decl = (ElementDecl)edge.getTerm();
                symbol = decl.getDisplayName();
            } else {
                Wildcard card = (Wildcard)edge.getTerm();
                symbol = card.toString();
            }
            AutomatonState target = edge.getTargetState();
            String counting = this.requiresCounter() && target == this ? " (min=" + this.getMinOccurs() + ", max=" + this.getMaxOccurs() + ")" : "";
            err.info("    " + symbol + counting + " -> " + target.stateNumber + AutomatonState.finalMarker(target));
        }
        if (this.maxTransition != null) {
            AutomatonState target = this.maxTransition.getTargetState();
            err.info("    onMax -> " + target.getStateNumber() + AutomatonState.finalMarker(target));
        }
    }

    public void displayLambdaTransitions() {
    }

    public void setMaxTransition(Edge edge) {
        this.maxTransition = edge;
    }

    public Edge getMaxTransition() {
        return this.maxTransition;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("state");
        serializer.emitAttribute("nr", this.stateNumber + "");
        if (this._isFinalState) {
            serializer.emitAttribute("final", "true");
        }
        if (this.requiresCounter()) {
            serializer.emitAttribute("minOccurs", "" + this.getMinOccurs());
            serializer.emitAttribute("maxOccurs", this.getMaxOccurs() == -1 ? "unbounded" : "" + this.getMaxOccurs());
            if (this.maxTransition != null) {
                serializer.emitAttribute("afterMax", this.maxTransition.getTargetState().getStateNumber() + "");
            }
        }
        for (Edge edge : this.iterateSpecificTransitions()) {
            edge.serialize(serializer);
        }
        if (this.wildcardEdges != null) {
            for (Edge edge : this.wildcardEdges) {
                edge.serialize(serializer);
            }
        }
        serializer.endElement();
    }
}

