/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeAlternative;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.XSDComplexType;
import com.saxonica.ee.schema.sdoc.XSDElement;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import java.util.HashMap;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

public class XSDAlternative
extends AnnotationParent {
    private TypeAlternative alternative = null;
    private static final int[] state0terms = new int[]{578, 621, 588};
    private static final int[] state0targets = new int[]{1, 2, 2};
    private static final int[] state1terms = new int[]{621, 588};
    private static final int[] state1targets = new int[]{2, 2};
    private static final int[] state2terms = new int[0];
    private static final int[] state2targets = new int[0];
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets};

    @Override
    protected void prepareAttributes() throws SchemaException {
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"id", "test", "type", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String defaultNamespace = atts.getValue(NamespaceUri.NULL, "xpathDefaultNamespace");
        if (defaultNamespace == null) {
            defaultNamespace = this.getXSDSchema().getXPathDefaultNamespace();
        }
        NamespaceUri defaultNamespaceUri = defaultNamespace.equals("##defaultNamespace") ? this.getURIForPrefix("", true) : (defaultNamespace.equals("##targetNamespace") ? this.getXSDSchema().getTargetNamespace() : (defaultNamespace.equals("##local") ? NamespaceUri.NULL : NamespaceUri.of(defaultNamespace)));
        String xpath = atts.getValue(NamespaceUri.NULL, "test");
        XPathExpression condition = null;
        HashMap<StructuredQName, XPathVariable> parameters = new HashMap<StructuredQName, XPathVariable>();
        if (xpath != null) {
            SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this);
            env.setDefaultElementNamespace(defaultNamespaceUri);
            env.setBaseURI(this.getBaseURI());
            env.setXPathLanguageLevel(this.getXSDSchema().getAllowedExtensions().contains("any-xpath-version") ? 31 : 20);
            for (GlobalParam param : this.getXSDSchema().getGlobalParams()) {
                XPathVariable var = env.declareVariable(param.getVariableQName());
                GroundedValue defaultVal = ((Literal)param.getBody()).getGroundedValue();
                var.setDefaultValue(defaultVal);
                parameters.put(param.getVariableQName(), var);
            }
            XPathEvaluator xpe = new XPathEvaluator(this.getSchema().getConfiguration());
            try {
                xpe.setStaticContext(env);
                condition = xpe.createExpression(xpath);
            }
            catch (XPathException err) {
                this.error(err.getMessage());
                try {
                    condition = xpe.createExpression("false()");
                }
                catch (XPathException var) {
                    // empty catch block
                }
            }
        }
        EnterpriseConfiguration config = this.getSchema().getConfiguration();
        this.alternative = new TypeAlternative(config, condition, xpath);
        this.alternative.setLocator(this);
        this.alternative.setNamespaceContext(this.makeNamespaceContext());
        this.alternative.setDefaultElementNamespace(defaultNamespaceUri);
        this.alternative.setBaseURI(this.getBaseURI());
        this.alternative.setParameters(parameters);
        String attValue = atts.getValue(NamespaceUri.NULL, "type");
        if (attValue != null) {
            try {
                int fp = this.getFingerprint(attValue, 0);
                if (fp == 632 || fp == 630) {
                    this.error("Type " + attValue + " cannot be used as an element type");
                }
                this.alternative.setTypeReference(new TypeReference(fp, config, this));
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
            }
        }
        this.processId();
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        this.checkContentModel(stateTerms, stateTargets, false);
        for (NodeInfo nodeInfo : this.children()) {
            int childfp = nodeInfo.getFingerprint();
            switch (childfp) {
                case 578: {
                    break;
                }
                case 588: {
                    if (this.alternative.getTypeReference() == null) break;
                    this.mutuallyExclusiveElementAndAttribute("complexType", "type");
                    break;
                }
                case 621: {
                    if (this.alternative.getTypeReference() == null) break;
                    this.mutuallyExclusiveElementAndAttribute("simpleType", "type");
                }
            }
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return state == 0 || state == 1 || state == 2;
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        EnterpriseConfiguration config = (EnterpriseConfiguration)this.getConfiguration();
        for (NodeInfo nodeInfo : this.children()) {
            int childfp = nodeInfo.getFingerprint();
            switch (childfp) {
                case 588: {
                    UserDefinedType schemaType = ((XSDComplexType)nodeInfo).getComplexType();
                    TypeReference ref = new TypeReference(schemaType.getFingerprint(), config, nodeInfo);
                    ref.setTarget(schemaType);
                    this.alternative.setTypeReference(ref);
                    schemaType.setContainingDeclaration(((XSDElement)this.getParent()).getElementDeclaration().getComponentName(), true);
                    break;
                }
                case 621: {
                    UserDefinedType schemaType = ((XSDSimpleType)nodeInfo).getSimpleTypeDefinition();
                    TypeReference ref = new TypeReference(schemaType.getFingerprint(), config, nodeInfo);
                    ref.setTarget(schemaType);
                    this.alternative.setTypeReference(ref);
                    schemaType.setContainingDeclaration(((XSDElement)this.getParent()).getElementDeclaration().getComponentName(), true);
                    break;
                }
            }
        }
    }

    public TypeAlternative getTypeAlternative() {
        return this.alternative;
    }
}

