/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.util.ArrayList;
import net.sf.saxon.expr.SubsequenceIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceExtent;

public class SaxonSlice
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Item index;
        int start;
        IntegerRange range;
        if (arguments[1] instanceof IntegerRange && (range = (IntegerRange)arguments[1]).getStep() == 1L && Math.abs(range.getStart()) < Integer.MAX_VALUE && Math.abs(range.getEnd()) < Integer.MAX_VALUE && (start = (int)range.getStart()) > 0) {
            return new LazySequence(SubsequenceIterator.make(arguments[0].iterate(), start, (int)range.getEnd()));
        }
        ArrayList<Item> selected = new ArrayList<Item>();
        GroundedValue input = arguments[0].materialize();
        int length = input.getLength();
        SequenceIterator indices = arguments[1].iterate();
        while ((index = indices.next()) != null) {
            int i;
            IntegerValue value = (IntegerValue)index;
            int sign = value.signum();
            if (sign == 0 || (i = value.abs().asSubscript()) < 0 || i > length) continue;
            if (sign < 0) {
                selected.add(input.itemAt(length - i));
                continue;
            }
            selected.add(input.itemAt(i - 1));
        }
        return SequenceExtent.makeSequenceExtent(selected);
    }
}

