/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntIterator;

public class UnescapeNCName
extends SystemFunction {
    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue arg = (StringValue)arguments[0].head();
        UnicodeString input = arg.getUnicodeStringValue();
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        if (!BuiltInAtomicType.NCNAME.matches(arg, th) && !NameChecker.isValidNCName(input.codePoints())) {
            throw new XPathException("Input to saxon:unescape-NCName must be a valid NCName: supplied value is '" + input + "'", "FORG0001");
        }
        if (input.length() == 1L && input.codePointAt(0L) == 95) {
            return new StringValue("");
        }
        UnicodeBuilder out = new UnicodeBuilder((int)input.estimatedLength());
        IntIterator iter = input.codePoints();
        block0: while (iter.hasNext()) {
            int ch = iter.next();
            if (ch == 95) {
                StringBuilder hex = new StringBuilder(6);
                while (iter.hasNext()) {
                    int digit = iter.next();
                    if (digit == 95) {
                        if (hex.length() == 0) {
                            out.append('_');
                            continue block0;
                        }
                        int code = Integer.parseInt(hex.toString(), 16);
                        if (!XMLCharacterData.isValid11(code)) {
                            throw new XPathException("Invalid escaped XML character: " + hex, "FORG0001");
                        }
                        out.append(code);
                        continue block0;
                    }
                    if (digit < 128 && "0123456789abcdefABCDEF".indexOf((char)digit) >= 0) {
                        hex.append((char)digit);
                        continue;
                    }
                    throw new XPathException("Invalid character '" + Integer.toHexString(digit) + " in escaped NCName");
                }
                continue;
            }
            out.append(ch);
        }
        return new StringValue(out.toUnicodeString(), (AtomicType)BuiltInAtomicType.NCNAME);
    }

    private void escape(int codepoint, UnicodeBuilder sb) {
        sb.append('_');
        sb.append(Integer.toHexString(codepoint));
        sb.append('_');
    }
}

