/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.namefind.TokenNameFinderModelLoader;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenNameFinderTool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(TokenNameFinderTool.class);

    @Override
    public String getShortDescription() {
        return "Learnable name finder";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model1 model2 ... modelN < sentences";
    }

    @Override
    public void run(String[] args2) {
        if (args2.length == 0) {
            logger.info(this.getHelp());
        } else {
            NameFinderME[] nameFinders = new NameFinderME[args2.length];
            for (int i = 0; i < nameFinders.length; ++i) {
                TokenNameFinderModel model = (TokenNameFinderModel)new TokenNameFinderModelLoader().load(new File(args2[i]));
                nameFinders[i] = new NameFinderME(model);
            }
            PerformanceMonitor perfMon = new PerformanceMonitor("sent");
            perfMon.start();
            try (PlainTextByLineStream untokenizedLineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());){
                String line;
                while ((line = (String)untokenizedLineStream.read()) != null) {
                    String[] whitespaceTokenizerLine = WhitespaceTokenizer.INSTANCE.tokenize(line);
                    if (whitespaceTokenizerLine.length == 0) {
                        for (NameFinderME nameFinder : nameFinders) {
                            nameFinder.clearAdaptiveData();
                        }
                    }
                    ArrayList names = new ArrayList();
                    for (NameFinderME nameFinder : nameFinders) {
                        Collections.addAll(names, nameFinder.find(whitespaceTokenizerLine));
                    }
                    Span[] reducedNames = NameFinderME.dropOverlappingSpans(names.toArray(new Span[0]));
                    NameSample nameSample = new NameSample(whitespaceTokenizerLine, reducedNames, false);
                    logger.info(nameSample.toString());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

