/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.util.ArrayList;
import java.util.Map;
import opennlp.tools.ml.naivebayes.Probabilities;
import opennlp.tools.ml.naivebayes.Probability;

public class LogProbabilities<T>
extends Probabilities<T> {
    @Override
    public void set(T t2, double probability) {
        this.isNormalised = false;
        this.map.put(t2, this.log(probability));
    }

    @Override
    public void set(T t2, Probability<T> probability) {
        this.isNormalised = false;
        this.map.put(t2, probability.getLog());
    }

    @Override
    public void setIfLarger(T t2, double probability) {
        double logProbability = this.log(probability);
        Double p = (Double)this.map.get(t2);
        if (p == null || logProbability > p) {
            this.isNormalised = false;
            this.map.put(t2, logProbability);
        }
    }

    @Override
    public void setLog(T t2, double probability) {
        this.isNormalised = false;
        this.map.put(t2, probability);
    }

    @Override
    public void addIn(T t2, double probability, int count2) {
        this.isNormalised = false;
        Double p = (Double)this.map.get(t2);
        if (p == null) {
            p = 0.0;
        }
        probability = this.log(probability) * (double)count2;
        this.map.put(t2, p + probability);
    }

    private Map<T, Double> normalize() {
        Double p;
        if (this.isNormalised) {
            return this.normalised;
        }
        Map temp = this.createMapDataStructure();
        double highestLogProbability = Double.NEGATIVE_INFINITY;
        for (Map.Entry entry : this.map.entrySet()) {
            Double p2 = (Double)entry.getValue();
            if (p2 == null || !(p2 > highestLogProbability)) continue;
            highestLogProbability = p2;
        }
        double sum = 0.0;
        for (Map.Entry entry : this.map.entrySet()) {
            double temp_p;
            Object t2 = entry.getKey();
            p = (Double)entry.getValue();
            if (p == null || Double.isNaN(temp_p = StrictMath.exp(p - highestLogProbability))) continue;
            sum += temp_p;
            temp.put(t2, temp_p);
        }
        for (Map.Entry<Object, Object> entry : temp.entrySet()) {
            Object t2 = entry.getKey();
            p = (Double)entry.getValue();
            if (p == null || !(sum > Double.MIN_VALUE)) continue;
            temp.put(t2, p / sum);
        }
        this.normalised = temp;
        this.isNormalised = true;
        return temp;
    }

    private double log(double prob) {
        return StrictMath.log(prob);
    }

    @Override
    public Double get(T t2) {
        Double d = this.normalize().get(t2);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public Double getLog(T t2) {
        Double d = (Double)this.map.get(t2);
        if (d == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return d;
    }

    @Override
    public void discardCountsBelow(double i) {
        i = StrictMath.log(i);
        ArrayList labelsToRemove = new ArrayList();
        for (Map.Entry entry : this.map.entrySet()) {
            Object label = entry.getKey();
            Double sum = (Double)entry.getValue();
            if (sum == null) {
                sum = Double.NEGATIVE_INFINITY;
            }
            if (!(sum < i)) continue;
            labelsToRemove.add(label);
        }
        for (Map.Entry label : labelsToRemove) {
            this.map.remove(label);
        }
    }

    @Override
    public Map<T, Double> getAll() {
        return this.normalize();
    }

    @Override
    public T getMax() {
        double max = Double.NEGATIVE_INFINITY;
        T maxT = null;
        for (Map.Entry entry : this.map.entrySet()) {
            Object t2 = entry.getKey();
            Double temp = (Double)entry.getValue();
            if (!(temp >= max)) continue;
            max = temp;
            maxT = (T)t2;
        }
        return maxT;
    }
}

