/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.util.QueryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.spans.Spans;

public class FrameConstraint {
    public static final int PRECEDES = 1;
    public static final int PRECEDES_DIRECTLY = 2;
    public static final int OVERLAPS_LEFT = 4;
    public static final int ALIGNS_LEFT = 8;
    public static final int STARTS_WITH = 16;
    public static final int MATCHES = 32;
    public static final int IS_WITHIN = 64;
    public static final int IS_AROUND = 128;
    public static final int ENDS_WITH = 256;
    public static final int ALIGNS_RIGHT = 512;
    public static final int OVERLAPS_RIGHT = 1024;
    public static final int SUCCEEDS_DIRECTLY = 2048;
    public static final int SUCCEEDS = 4096;
    public static final int ALL = 8191;
    private static final Map<String, Integer> FRAME;
    private static final List<Integer> NEXT_B;
    public int vector = 0;

    public FrameConstraint add(String condition) throws QueryException {
        int or = FRAME.get(condition);
        if (or == 0) {
            throw new QueryException(706, "Frame type is unknown");
        }
        this.vector |= or;
        return this;
    }

    public FrameConstraint add(FrameConstraint constraint) {
        this.vector |= constraint.vector;
        return this;
    }

    public FrameConstraint invert() {
        this.vector ^= 0x1FFF;
        return this;
    }

    public boolean check(String condition) throws QueryException {
        int check = FRAME.get(condition);
        if (check == 0) {
            throw new QueryException(706, "Frame type is unknown");
        }
        return this.check(check);
    }

    public boolean check(int conditions) {
        return (this.vector & conditions) != 0;
    }

    public boolean check(FrameConstraint conditions) {
        return (this.vector & conditions.vector) != 0;
    }

    private static int _next_b(int constellation) {
        return NEXT_B.get(Integer.numberOfTrailingZeros(constellation));
    }

    public int _constellation(Spans a, Spans b) {
        if (a.start() > b.start()) {
            if (a.start() == b.end()) {
                return 2048;
            }
            if (a.start() > b.end()) {
                return 4096;
            }
            if (a.end() == b.end()) {
                return 512;
            }
            if (a.end() < b.end()) {
                return 64;
            }
            return 1024;
        }
        if (a.start() < b.start()) {
            if (a.end() == b.start()) {
                return 2;
            }
            if (a.end() < b.start()) {
                return 1;
            }
            if (a.end() == b.end()) {
                return 256;
            }
            if (a.end() > b.end()) {
                return 128;
            }
            return 4;
        }
        if (a.end() > b.end()) {
            return 16;
        }
        if (a.end() < b.end()) {
            return 8;
        }
        return 32;
    }

    static {
        HashMap<String, Integer> FRAME_t = new HashMap<String, Integer>();
        ArrayList<Integer> NEXT_B_t = new ArrayList<Integer>(16);
        FRAME_t.put("precedes", 1);
        NEXT_B_t.add(1);
        FRAME_t.put("precedesDirectly", 2);
        NEXT_B_t.add(3);
        FRAME_t.put("overlapsLeft", 4);
        NEXT_B_t.add(7);
        FRAME_t.put("alignsLeft", 8);
        NEXT_B_t.add(15);
        FRAME_t.put("startsWith", 16);
        NEXT_B_t.add(447);
        FRAME_t.put("matches", 32);
        NEXT_B_t.add(303);
        FRAME_t.put("isWithin", 64);
        NEXT_B_t.add(75);
        FRAME_t.put("isAround", 128);
        NEXT_B_t.add(391);
        FRAME_t.put("endsWith", 256);
        NEXT_B_t.add(263);
        FRAME_t.put("alignsRight", 512);
        NEXT_B_t.add(619);
        FRAME_t.put("overlapsRight", 1024);
        NEXT_B_t.add(2047);
        FRAME_t.put("succeedsDirectly", 2048);
        NEXT_B_t.add(4095);
        FRAME_t.put("succeeds", 4096);
        NEXT_B_t.add(6779);
        FRAME = Collections.unmodifiableMap(FRAME_t);
        NEXT_B = Collections.unmodifiableList(NEXT_B_t);
    }
}

