/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanExpansionQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class ExpandedExclusionSpans
extends SimpleSpans {
    private int min;
    private int max;
    private int direction;
    private byte classNumber;
    private List<CandidateSpan> candidateSpans;
    private boolean hasMoreNotClause;
    private Spans notClause;
    private long matchCost;

    public ExpandedExclusionSpans(SpanExpansionQuery spanExpansionQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(spanExpansionQuery, context, acceptDocs, termContexts);
        if (spanExpansionQuery.getSecondClause() == null) {
            throw new IllegalArgumentException("The SpanExpansionQuery is not valid. The spanquery to exclude (notClause) cannot be null.");
        }
        this.min = spanExpansionQuery.getMin();
        this.max = spanExpansionQuery.getMax();
        this.direction = spanExpansionQuery.getDirection();
        this.classNumber = spanExpansionQuery.getClassNumber();
        this.notClause = this.secondSpans;
        this.hasMoreNotClause = this.notClause.next();
        this.candidateSpans = new ArrayList<CandidateSpan>();
        this.hasMoreSpans = this.firstSpans.next();
    }

    @Override
    public boolean next() throws IOException {
        this.matchPayload.clear();
        this.isStartEnumeration = false;
        return this.advance();
    }

    private boolean advance() throws IOException {
        while (this.hasMoreSpans || this.candidateSpans.size() > 0) {
            if (this.candidateSpans.size() > 0) {
                CandidateSpan cs = this.candidateSpans.get(0);
                this.matchDocNumber = cs.getDoc();
                this.matchStartPosition = cs.getStart();
                this.matchEndPosition = cs.getEnd();
                this.matchPayload = cs.getPayloads();
                this.matchCost = cs.getCost() + this.notClause.cost();
                this.candidateSpans.remove(0);
                return true;
            }
            if (!this.hasMoreNotClause || this.notClause.doc() > this.firstSpans.doc()) {
                this.generateCandidates(this.min, this.max, this.direction);
                this.hasMoreSpans = this.firstSpans.next();
                continue;
            }
            this.findMatches();
        }
        return false;
    }

    private void findMatches() throws IOException {
        while (this.hasMoreNotClause && this.notClause.doc() <= this.firstSpans.doc()) {
            if (this.notClause.doc() == this.firstSpans.doc()) {
                if (this.direction < 0) {
                    this.expandLeft();
                    break;
                }
                this.expandRight();
                break;
            }
            if (this.notClause.next()) continue;
            this.hasMoreNotClause = false;
        }
    }

    private void expandLeft() throws IOException {
        int maxPos = this.max;
        CandidateSpan lastNotClause = null;
        while (this.hasMoreNotClause && this.notClause.doc() == this.firstSpans.doc() && this.notClause.start() < this.firstSpans.start()) {
            if (this.notClause.start() >= this.firstSpans.start() - maxPos) {
                maxPos = this.firstSpans.start() - this.notClause.start() - 1;
                lastNotClause = new CandidateSpan(this.notClause);
            }
            if (this.notClause.next()) continue;
            this.hasMoreNotClause = false;
        }
        this.generateCandidates(this.min, maxPos, this.direction);
        if (lastNotClause != null && this.hasMoreNotClause) {
            while ((this.hasMoreSpans = this.firstSpans.next()) && this.notClause.start() > this.firstSpans.start() && lastNotClause.getStart() < this.firstSpans.start() && lastNotClause.getStart() >= this.firstSpans.start() - this.max) {
                maxPos = this.firstSpans.start() - lastNotClause.getStart() - 1;
                this.generateCandidates(this.min, maxPos, this.direction);
            }
        } else {
            this.hasMoreSpans = this.firstSpans.next();
        }
    }

    private void expandRight() throws IOException {
        int expansionEnd = this.firstSpans.end() + this.max;
        int maxPos = this.max;
        boolean isFound = false;
        CandidateSpan firstNotClause = null;
        while (this.hasMoreNotClause && this.notClause.doc() == this.firstSpans.doc() && this.notClause.start() < expansionEnd) {
            if (!isFound && this.notClause.start() >= this.firstSpans.end()) {
                maxPos = this.notClause.start() - this.firstSpans.end() - 1;
                firstNotClause = new CandidateSpan(this.notClause);
                isFound = true;
            }
            if (this.notClause.next()) continue;
            this.hasMoreNotClause = false;
        }
        this.generateCandidates(this.min, maxPos, this.direction);
        if (firstNotClause != null) {
            while ((this.hasMoreSpans = this.firstSpans.next()) && firstNotClause.getStart() < this.firstSpans.end() + this.max && firstNotClause.getStart() >= this.firstSpans.end()) {
                maxPos = firstNotClause.getStart() - this.firstSpans.end() - 1;
                this.generateCandidates(this.min, maxPos, this.direction);
            }
        } else {
            this.hasMoreSpans = this.firstSpans.next();
        }
    }

    private void generateCandidates(int minPos, int maxPos, int direction) throws IOException {
        if (direction < 0) {
            for (int counter = maxPos; counter >= this.min; --counter) {
                int start = Math.max(0, this.firstSpans.start() - counter);
                if (start <= -1) continue;
                int end = this.firstSpans.end();
                CandidateSpan cs = new CandidateSpan(start, end, this.firstSpans.doc(), this.firstSpans.cost(), this.createPayloads(start, this.firstSpans.start()));
                this.candidateSpans.add(cs);
            }
        } else {
            for (int counter = minPos; counter <= maxPos; ++counter) {
                int start = this.firstSpans.start();
                int end = this.firstSpans.end() + counter;
                CandidateSpan cs = new CandidateSpan(start, end, this.firstSpans.doc(), this.firstSpans.cost(), this.createPayloads(this.firstSpans.end(), end));
                this.candidateSpans.add(cs);
            }
        }
    }

    private ArrayList<byte[]> createPayloads(int start, int end) throws IOException {
        ArrayList<byte[]> payload = new ArrayList<byte[]>();
        if (this.firstSpans.isPayloadAvailable()) {
            payload.addAll(this.firstSpans.getPayload());
        }
        if (this.classNumber > 0) {
            payload.add(this.createExtensionPayloads(start, end));
        }
        return payload;
    }

    private byte[] createExtensionPayloads(int start, int end) {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        Byte classPTI = 0;
        buffer.put(classPTI);
        buffer.putInt(start);
        buffer.putInt(end);
        buffer.put(this.classNumber);
        return buffer.array();
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.hasMoreSpans = false;
            return false;
        }
        this.matchPayload.clear();
        return this.advance();
    }

    @Override
    public long cost() {
        return this.matchCost;
    }
}

