/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.adjunct.FilteringAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;

public class OutermostStreamer
extends FilteringAdjunct
implements FeedMaker {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        PostureAndSweep ps = super.computeStreamability(contextInfo, reasons);
        if (ps.getPosture() == Posture.CRAWLING) {
            return new PostureAndSweep(Posture.STRIDING, ps.getSweep());
        }
        return ps;
    }

    @Override
    public FilteringFeed.Filter makeFilter(XPathContext context, Feed out) throws XPathException {
        return new OutermostFilter();
    }

    private static class OutermostFilter
    implements FilteringFeed.Filter {
        private NodeInfo previous = null;

        @Override
        public int matches(Item item, int position) {
            if (this.previous == null || !Navigator.isAncestorOrSelf(this.previous, (NodeInfo)item)) {
                this.previous = (NodeInfo)item;
                return 1;
            }
            return 0;
        }
    }
}

