/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.ExceptPattern;
import net.sf.saxon.pattern.IntersectPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.PrependSequenceIterator;

public class VennExpressionAdjunct
extends TransmissionAdjunct {
    @Override
    public Pattern toStreamingPattern(Configuration config) {
        VennExpression exp = (VennExpression)this.getExpression();
        Expression e0 = exp.getLhsExpression();
        Expression e1 = exp.getRhsExpression();
        int operator = exp.getOperator();
        Pattern p0 = VennExpressionAdjunct.makeStreamingPattern(e0, config);
        if (p0 == null) {
            return null;
        }
        Pattern p1 = VennExpressionAdjunct.makeStreamingPattern(e1, config);
        if (p1 == null) {
            return null;
        }
        if (operator == 1) {
            return new UnionPattern(p0, p1);
        }
        if (operator == 24) {
            return new ExceptPattern(p0, p1);
        }
        return new IntersectPattern(p0, p1);
    }

    private static Pattern makeStreamingPattern(Expression e, Configuration config) {
        if (Streamability.getPostureAndSweepIfKnown(e) != null && Streamability.getPosture(e) == Posture.GROUNDED) {
            return null;
        }
        return Streamability.toStreamingPattern(e, config);
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        VennExpression exp = (VennExpression)this.getExpression();
        PostureAndSweep ps0 = Streamability.getStreamability(exp.getLhsExpression(), contextInfo, reasons);
        PostureAndSweep ps1 = Streamability.getStreamability(exp.getRhsExpression(), contextInfo, reasons);
        if (ps0.getSweep() == Sweep.FREE_RANGING || ps1.getSweep() == Sweep.FREE_RANGING) {
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (ps0.equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) {
            return ps1;
        }
        if (ps1.equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) {
            return ps0;
        }
        if (ps0.equals(PostureAndSweep.CLIMBING_AND_MOTIONLESS) && ps1.equals(PostureAndSweep.CLIMBING_AND_MOTIONLESS)) {
            return ps0;
        }
        Posture p0 = ps0.getPosture();
        Posture p1 = ps1.getPosture();
        if (!(p0 != Posture.STRIDING && p0 != Posture.CRAWLING || p1 != Posture.STRIDING && p1 != Posture.CRAWLING)) {
            return new PostureAndSweep(Posture.CRAWLING, Sweep.wider(ps0.getSweep(), ps1.getSweep()));
        }
        if (reasons != null) {
            reasons.add("Operands of " + Token.tokens[exp.getOperator()] + " expression on line " + exp.getLocation().getLineNumber() + " have mixed posture");
        }
        return PostureAndSweep.ROAMING_AND_FREE_RANGING;
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        final VennExpression exp = (VennExpression)this.getExpression();
        Sweep s0 = Streamability.getSweep(exp.getLhsExpression());
        Sweep s1 = Streamability.getSweep(exp.getRhsExpression());
        boolean a0consuming = s0 == Sweep.CONSUMING;
        int operator = exp.getOperator();
        if (operator == 1) {
            if (a0consuming) {
                return new UnionFeed(exp, exp.getRhsExpression(), out, context);
            }
            return new UnionFeed(exp, exp.getLhsExpression(), out, context);
        }
        if (operator == 23) {
            return new FilteringFeed(out, context, new FilteringFeed.OpaqueFilter());
        }
        if (operator == 24) {
            if (a0consuming) {
                return new FilteringFeed(out, context, new FilteringFeed.TransparentFilter());
            }
            return new FilteringFeed(out, context, new FilteringFeed.OpaqueFilter()){

                @Override
                public void open(Terminator terminator) throws XPathException {
                    super.open(terminator);
                    1.processItems(exp.getLhsExpression().iterate(this.getContext()), this.getResult());
                }
            };
        }
        throw new UnsupportedOperationException();
    }

    private static class UnionFeed
    extends ItemFeed {
        Expression nonConsumingOperand;
        SequenceIterator<NodeInfo> nonConsumingIterator;
        boolean atStart = true;
        boolean emitNonConsumingOperandAtEnd = true;

        public UnionFeed(Expression exp, Expression nonConsumingOperand, Feed result, XPathContext context) {
            super(exp, result, context);
            this.nonConsumingOperand = nonConsumingOperand;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.nonConsumingIterator = this.nonConsumingOperand.iterate(this.getContext());
        }

        @Override
        public void close() throws XPathException {
            if (this.emitNonConsumingOperandAtEnd) {
                UnionFeed.processItems(this.nonConsumingIterator, this.getResult());
            }
            this.getResult().close();
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (this.atStart) {
                NodeInfo first = this.nonConsumingIterator.next();
                if (first != null) {
                    if (GlobalOrderComparer.getInstance().compare(item, first) < 0) {
                        this.nonConsumingIterator = new PrependSequenceIterator<NodeInfo>(first, this.nonConsumingIterator);
                        this.emitNonConsumingOperandAtEnd = true;
                    } else {
                        this.getResult().processItem(first);
                        UnionFeed.processItems(this.nonConsumingIterator, this.getResult());
                        this.emitNonConsumingOperandAtEnd = false;
                    }
                } else {
                    this.emitNonConsumingOperandAtEnd = false;
                }
            }
            this.atStart = false;
            this.getResult().processItem(item);
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (this.atStart) {
                NodeInfo first = this.nonConsumingIterator.next();
                if (first != null) {
                    if (GlobalOrderComparer.getInstance().compare(node, first) < 0) {
                        this.nonConsumingIterator = new PrependSequenceIterator<NodeInfo>(first, this.nonConsumingIterator);
                        this.emitNonConsumingOperandAtEnd = true;
                    } else {
                        this.getResult().processItem(first);
                        UnionFeed.processItems(this.nonConsumingIterator, this.getResult());
                        this.emitNonConsumingOperandAtEnd = false;
                    }
                } else {
                    this.emitNonConsumingOperandAtEnd = false;
                }
            }
            this.atStart = false;
            return this.getResult().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.getResult().endSelectedParentNode(locationId);
        }
    }
}

