/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class InSituValidator {
    private MutableNodeInfo[] nodeBuffer = new MutableNodeInfo[16];
    private MutableNodeInfo root;
    private int validationMode;

    public InSituValidator(MutableNodeInfo root, int validationMode) {
        this.root = root;
        this.validationMode = validationMode;
    }

    public void validate() throws XPathException {
        Receiver validator;
        Configuration config = this.root.getConfiguration();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setHostLanguage(52);
        NodeUpdater endPoint = new NodeUpdater(pipe);
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(this.validationMode);
        options.setSpaceStrippingRule(null);
        if (this.root.getNodeKind() == 9) {
            validator = config.getDocumentValidator(endPoint, this.root.getSystemId(), options, null);
        } else {
            options.setTopLevelElement(NameOfNode.makeName(this.root).getStructuredQName());
            validator = config.getElementValidator(endPoint, options, ExplicitLocation.UNKNOWN_LOCATION);
        }
        pipe.setComponent(CopyInformee.class.getName(), new NodeCounter(validator));
        this.root.copy(validator, 2, ExplicitLocation.UNKNOWN_LOCATION);
    }

    private class NodeUpdater
    extends ProxyReceiver {
        private MutableNodeInfo currentElement;

        public NodeUpdater(PipelineConfiguration pipe) {
            super(new Sink(pipe));
        }

        @Override
        public void startElement(NodeName nameCode, SchemaType type, Location location, int properties) throws XPathException {
            MutableNodeInfo node = InSituValidator.this.nodeBuffer[location.getLineNumber() % 16];
            node.setTypeAnnotation(type);
            this.currentElement = node;
        }

        @Override
        public void attribute(NodeName name, SimpleType type, CharSequence value, Location locationId, int properties) throws XPathException {
            if ((properties & 8) != 0) {
                this.currentElement.addAttribute(name, type, value, 0);
            } else {
                NodeInfo att;
                AxisIterator axis = this.currentElement.iterateAxis((byte)2);
                while ((att = axis.next()) != null) {
                    if (!NameOfNode.makeName(att).equals(name)) continue;
                    ((MutableNodeInfo)att).setTypeAnnotation(type);
                    axis.close();
                    break;
                }
            }
        }

        @Override
        public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
            if ((properties & 8) != 0) {
                Orphan child = new Orphan(this.getConfiguration());
                child.setNodeKind((short)3);
                child.setStringValue(chars.toString());
                this.currentElement.insertChildren(new NodeInfo[]{child}, true, true);
            }
            super.characters(chars, locationId, properties);
        }

        @Override
        public boolean usesTypeAnnotations() {
            return true;
        }
    }

    private class NodeCounter
    implements CopyInformee<Location> {
        int counter = 0;

        public NodeCounter(Receiver next) {
        }

        @Override
        public Location notifyElementNode(NodeInfo element) {
            ((InSituValidator)InSituValidator.this).nodeBuffer[this.counter % 16] = (MutableNodeInfo)element;
            return new ExplicitLocation(element.getSystemId(), this.counter++, 998877);
        }
    }
}

