/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.CalculatorCompiler;
import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;

public class ArithmeticCompiler
extends ToItemCompiler {
    public static Map<Class<? extends Calculator>, Class<? extends CalculatorCompiler>> map = new ConcurrentHashMap<Class<? extends Calculator>, Class<? extends CalculatorCompiler>>(60);

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ArithmeticExpression exp = (ArithmeticExpression)expression;
        ArithmeticCompiler.visitAnnotation(compiler, "ArithmeticCompiler");
        LabelInfo end = methodInfo.newLabel("endArith");
        compiler.compileToItem(exp.getLhsExpression());
        ga.checkClass(AtomicValue.class);
        ArithmeticCompiler.visitAnnotation(compiler, "ArithmeticCompiler-doneArg-0");
        if (Cardinality.allowsZero(exp.getLhsExpression().getCardinality())) {
            LabelInfo notNull0 = methodInfo.newLabel("notNull0");
            ga.dup();
            ga.ifNonNull(notNull0.label());
            ga.pop();
            ga.push((String)null);
            ga.goTo(end);
            methodInfo.placeLabel(notNull0);
        }
        compiler.compileToItem(exp.getRhsExpression());
        ga.checkClass(AtomicValue.class);
        ArithmeticCompiler.visitAnnotation(compiler, "ArithmeticCompiler-doneArg-1");
        if (Cardinality.allowsZero(exp.getRhsExpression().getCardinality())) {
            LabelInfo notNull1 = methodInfo.newLabel("notNull1");
            ga.dup();
            ga.ifNonNull(notNull1.label());
            ga.pop2();
            ga.pushNull();
            ga.goTo(end);
            methodInfo.placeLabel(notNull1);
        }
        ArithmeticCompiler.visitLineNumber(compiler, ga, expression);
        Calculator calc = exp.getCalculator();
        Class<? extends CalculatorCompiler> myCalcCompiler = ArithmeticCompiler.map(calc);
        if (myCalcCompiler != null) {
            CalculatorCompiler myCalc;
            try {
                myCalc = myCalcCompiler.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CannotCompileException(expression, e.getMessage());
            }
            myCalc.setCompilerService(compiler);
            myCalc.setExpressions(exp.getLhsExpression(), exp.getRhsExpression());
            myCalc.compute(ga, expression.getLocation());
        } else {
            ArithmeticCompiler.allocateStatic(compiler, calc);
            ga.dupX2();
            ga.pop();
            compiler.generateGetContext();
            ga.invokeInstanceMethod(Calculator.class, "compute", AtomicValue.class, AtomicValue.class, XPathContext.class);
        }
        methodInfo.placeLabel(end);
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        ArithmeticExpression exp = (ArithmeticExpression)expression;
        ArithmeticCompiler.visitAnnotation(compiler, "ArithmeticCompiler");
        ItemType t0 = exp.getLhsExpression().getItemType();
        ItemType t1 = exp.getRhsExpression().getItemType();
        if (requiredClass == String.class || requiredClass == CharSequence.class) {
            compiler.compileToItem(exp.getLhsExpression());
            ga.checkClass(NumericValue.class);
            ga.invokeInstanceMethod(NumericValue.class, "getDoubleValue", new Class[0]);
            compiler.compileToItem(exp.getLhsExpression());
            ga.checkClass(NumericValue.class);
            ga.invokeInstanceMethod(NumericValue.class, "getDoubleValue", new Class[0]);
            this.generateDoubleOperator((ArithmeticExpression)expression, ga);
            ga.invokeStaticMethod(DoubleValue.class, "doubleToString", Double.TYPE);
            if (requiredClass == String.class) {
                ga.invokeInstanceMethod(CharSequence.class, "toString", new Class[0]);
            }
        } else if (requiredClass == Double.TYPE) {
            if (th.isSubType(t0, BuiltInAtomicType.DOUBLE)) {
                compiler.compileToPrimitive(exp.getLhsExpression(), Double.TYPE, onEmpty);
            } else {
                compiler.compileToItem(exp.getLhsExpression());
                ga.checkClass(NumericValue.class);
                ga.invokeInstanceMethod(NumericValue.class, "getDoubleValue", new Class[0]);
            }
            if (onEmpty instanceof OnEmpty.UnwindAndJump) {
                ((OnEmpty.UnwindAndJump)onEmpty).getUnwindStack().push(Double.TYPE);
            }
            if (th.isSubType(t1, BuiltInAtomicType.DOUBLE)) {
                compiler.compileToPrimitive(exp.getRhsExpression(), Double.TYPE, onEmpty);
            } else {
                compiler.compileToItem(exp.getRhsExpression());
                ga.checkClass(NumericValue.class);
                ga.invokeInstanceMethod(NumericValue.class, "getDoubleValue", new Class[0]);
            }
            this.generateDoubleOperator((ArithmeticExpression)expression, ga);
            if (onEmpty instanceof OnEmpty.UnwindAndJump) {
                ((OnEmpty.UnwindAndJump)onEmpty).getUnwindStack().pop();
            }
        } else if (requiredClass == Float.TYPE) {
            if (th.isSubType(t0, BuiltInAtomicType.FLOAT)) {
                compiler.compileToPrimitive(exp.getLhsExpression(), Float.TYPE, onEmpty);
            } else {
                compiler.compileToItem(exp.getLhsExpression());
                ga.checkClass(NumericValue.class);
                ga.invokeInstanceMethod(NumericValue.class, "getFloatValue", new Class[0]);
            }
            if (!(onEmpty instanceof OnEmpty.ReturnNull)) {
                ((OnEmpty.UnwindAndJump)onEmpty).getUnwindStack().push(Float.TYPE);
            }
            if (th.isSubType(t1, BuiltInAtomicType.FLOAT)) {
                compiler.compileToPrimitive(exp.getRhsExpression(), Float.TYPE, onEmpty);
            } else {
                compiler.compileToItem(exp.getRhsExpression());
                ga.checkClass(NumericValue.class);
                ga.invokeInstanceMethod(NumericValue.class, "getFloatValue", new Class[0]);
            }
            switch (((ArithmeticExpression)expression).getOperator()) {
                case 15: {
                    ga.math(96, Type.FLOAT_TYPE);
                    break;
                }
                case 16: {
                    ga.math(100, Type.FLOAT_TYPE);
                    break;
                }
                case 17: {
                    ga.math(104, Type.FLOAT_TYPE);
                    break;
                }
                case 18: {
                    ga.math(108, Type.FLOAT_TYPE);
                    break;
                }
                case 19: {
                    ga.math(112, Type.FLOAT_TYPE);
                    break;
                }
                case 56: {
                    ga.math(108, Type.FLOAT_TYPE);
                    break;
                }
                default: {
                    throw new CannotCompileException();
                }
            }
            if (!(onEmpty instanceof OnEmpty.ReturnNull)) {
                ((OnEmpty.UnwindAndJump)onEmpty).getUnwindStack().pop();
            }
        } else if (requiredClass == Long.TYPE || requiredClass == Integer.TYPE) {
            if (th.isSubType(t0, BuiltInAtomicType.INTEGER)) {
                compiler.compileToPrimitive(exp.getLhsExpression(), Long.TYPE, onEmpty);
            } else {
                compiler.compileToItem(exp.getLhsExpression());
                ga.checkClass(NumericValue.class);
                ga.invokeInstanceMethod(NumericValue.class, "longValue", new Class[0]);
            }
            if (onEmpty instanceof OnEmpty.UnwindAndJump) {
                ((OnEmpty.UnwindAndJump)onEmpty).getUnwindStack().push(Long.TYPE);
            }
            if (th.isSubType(t1, BuiltInAtomicType.INTEGER)) {
                compiler.compileToPrimitive(exp.getRhsExpression(), Long.TYPE, onEmpty);
            } else {
                compiler.compileToItem(exp.getRhsExpression());
                ga.checkClass(NumericValue.class);
                ga.invokeInstanceMethod(NumericValue.class, "longValue", new Class[0]);
            }
            switch (((ArithmeticExpression)expression).getOperator()) {
                case 15: {
                    ga.math(96, Type.LONG_TYPE);
                    break;
                }
                case 16: {
                    ga.math(100, Type.LONG_TYPE);
                    break;
                }
                case 17: {
                    ga.math(104, Type.LONG_TYPE);
                    break;
                }
                case 18: {
                    ga.math(108, Type.LONG_TYPE);
                    break;
                }
                case 19: {
                    ga.math(112, Type.LONG_TYPE);
                    break;
                }
                case 56: {
                    ga.math(108, Type.LONG_TYPE);
                    break;
                }
                default: {
                    throw new CannotCompileException();
                }
            }
            if (onEmpty instanceof OnEmpty.UnwindAndJump) {
                ((OnEmpty.UnwindAndJump)onEmpty).getUnwindStack().pop();
            }
            if (requiredClass == Integer.TYPE) {
                ga.cast(Type.LONG_TYPE, Type.INT_TYPE);
            }
        } else {
            throw new CannotCompileException();
        }
    }

    private void generateDoubleOperator(ArithmeticExpression expression, Generator ga) throws CannotCompileException {
        switch (expression.getOperator()) {
            case 15: {
                ga.math(96, Type.DOUBLE_TYPE);
                break;
            }
            case 16: {
                ga.math(100, Type.DOUBLE_TYPE);
                break;
            }
            case 17: {
                ga.math(104, Type.DOUBLE_TYPE);
                break;
            }
            case 18: {
                ga.math(108, Type.DOUBLE_TYPE);
                break;
            }
            case 19: {
                ga.math(112, Type.DOUBLE_TYPE);
                break;
            }
            case 56: {
                ga.math(108, Type.DOUBLE_TYPE);
                break;
            }
            default: {
                throw new CannotCompileException();
            }
        }
    }

    public static Class<? extends CalculatorCompiler> map(Calculator calc) {
        return map.get(calc.getClass());
    }

    private static void def(Class<? extends Calculator> c, Class<? extends CalculatorCompiler> cg) {
        map.put(c, cg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<ArithmeticCompiler> clazz = ArithmeticCompiler.class;
        synchronized (ArithmeticCompiler.class) {
            ArithmeticCompiler.def(Calculator.IntegerPlusInteger.class, CalculatorCompiler.IntegerPlusInteger.class);
            ArithmeticCompiler.def(Calculator.IntegerMinusInteger.class, CalculatorCompiler.IntegerMinusInteger.class);
            ArithmeticCompiler.def(Calculator.IntegerTimesInteger.class, CalculatorCompiler.IntegerTimesInteger.class);
            ArithmeticCompiler.def(Calculator.IntegerDivInteger.class, CalculatorCompiler.IntegerDivInteger.class);
            ArithmeticCompiler.def(Calculator.IntegerModInteger.class, CalculatorCompiler.IntegerModInteger.class);
            ArithmeticCompiler.def(Calculator.IntegerIdivInteger.class, CalculatorCompiler.IntegerIdivInteger.class);
            ArithmeticCompiler.def(Calculator.AnyPlusAny.class, CalculatorCompiler.AnyPlusAny.class);
            ArithmeticCompiler.def(Calculator.AnyMinusAny.class, CalculatorCompiler.AnyMinusAny.class);
            ArithmeticCompiler.def(Calculator.AnyTimesAny.class, CalculatorCompiler.AnyTimesAny.class);
            ArithmeticCompiler.def(Calculator.AnyDivAny.class, CalculatorCompiler.AnyDivAny.class);
            ArithmeticCompiler.def(Calculator.AnyModAny.class, CalculatorCompiler.AnyModAny.class);
            ArithmeticCompiler.def(Calculator.AnyIdivAny.class, CalculatorCompiler.AnyIdivAny.class);
            ArithmeticCompiler.def(Calculator.DoublePlusDouble.class, CalculatorCompiler.DoublePlusDouble.class);
            ArithmeticCompiler.def(Calculator.DoubleMinusDouble.class, CalculatorCompiler.DoubleMinusDouble.class);
            ArithmeticCompiler.def(Calculator.DoubleTimesDouble.class, CalculatorCompiler.DoubleTimesDouble.class);
            ArithmeticCompiler.def(Calculator.DoubleModDouble.class, CalculatorCompiler.DoubleModDouble.class);
            ArithmeticCompiler.def(Calculator.DoubleDivDouble.class, CalculatorCompiler.DoubleDivDouble.class);
            ArithmeticCompiler.def(Calculator.DecimalPlusDecimal.class, CalculatorCompiler.DecimalPlusDecimal.class);
            ArithmeticCompiler.def(Calculator.DecimalMinusDecimal.class, CalculatorCompiler.DecimalMinusDecimal.class);
            ArithmeticCompiler.def(Calculator.DecimalTimesDecimal.class, CalculatorCompiler.DecimalTimesDecimal.class);
            ArithmeticCompiler.def(Calculator.DecimalDivDecimal.class, CalculatorCompiler.DecimalDivDecimal.class);
            ArithmeticCompiler.def(Calculator.DecimalModDecimal.class, CalculatorCompiler.DecimalModDecimal.class);
            ArithmeticCompiler.def(Calculator.DecimalIdivDecimal.class, CalculatorCompiler.DecimalIdivDecimal.class);
            ArithmeticCompiler.def(Calculator.FloatPlusFloat.class, CalculatorCompiler.FloatPlusFloat.class);
            ArithmeticCompiler.def(Calculator.FloatMinusFloat.class, CalculatorCompiler.FloatMinusFloat.class);
            ArithmeticCompiler.def(Calculator.FloatTimesFloat.class, CalculatorCompiler.FloatTimesFloat.class);
            ArithmeticCompiler.def(Calculator.FloatDivFloat.class, CalculatorCompiler.FloatDivFloat.class);
            ArithmeticCompiler.def(Calculator.FloatModFloat.class, CalculatorCompiler.FloatModFloat.class);
            ArithmeticCompiler.def(Calculator.FloatIdivFloat.class, CalculatorCompiler.FloatIdivFloat.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

