/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.SimpleNodeConstructorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.NamespaceConstructor;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NamespaceConstructorCompiler
extends SimpleNodeConstructorCompiler {
    @Override
    protected boolean isNamedNodeKind() {
        return true;
    }

    @Override
    protected void compileNodeName(CompilerService compiler, Expression expression) throws CannotCompileException {
        NamespaceConstructor instr = (NamespaceConstructor)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo nameOK = methodInfo.newLabel("nameOK");
        if (((NamespaceConstructor)expression).isXSLT()) {
            compiler.compileToPrimitive(instr.getNameExp(), CharSequence.class, OnEmpty.RETURN_NULL);
        } else {
            compiler.compileToItem(instr.getNameExp());
            if (Cardinality.allowsZero(instr.getNameExp().getCardinality())) {
                LabelInfo nameNotNull = methodInfo.newLabel("nameNotNull");
                ga.dup();
                ga.ifNonNull(nameNotNull.label());
                ga.pop();
                ga.push("");
                ga.goTo(nameOK);
                methodInfo.placeLabel(nameNotNull);
            }
            ga.checkClass(AtomicValue.class);
            LabelInfo isString = methodInfo.newLabel("isString");
            LabelInfo isNotString = methodInfo.newLabel("isNotString");
            ga.dup();
            ga.ifNotInstance(StringValue.class, isNotString);
            ga.dup();
            ga.ifInstance(AnyURIValue.class, isNotString);
            ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
            ga.goTo(isString);
            methodInfo.placeLabel(isNotString);
            compiler.generateDynamicError("Namespace prefix is not an xs:string or xs:untypedAtomic", "XPTY0004", expression.getLocation(), true);
            methodInfo.placeLabel(isString);
        }
        ga.invokeStaticMethod(Whitespace.class, "trim", CharSequence.class);
        ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
        ga.dup();
        ga.invokeInstanceMethod(CharSequence.class, "length", new Class[0]);
        ga.ifZCmp(153, nameOK.label());
        ga.dup();
        ga.invokeStaticMethod(NameChecker.class, "isValidNCName", CharSequence.class);
        LabelInfo validNCName = methodInfo.newLabel("validNCName");
        ga.ifTrue(validNCName);
        compiler.generateDynamicError("Namespace prefix is invalid", instr.isXSLT() ? "XTDE0920" : "XQDY0074", instr.getLocation(), false);
        methodInfo.placeLabel(validNCName);
        ga.dup();
        ga.push("xmlns");
        ga.invokeInstanceMethod(Object.class, "equals", Object.class);
        ga.ifFalse(nameOK);
        compiler.generateDynamicError("Namespace prefix must not be 'xmlns'", instr.isXSLT() ? "XTDE0920" : "XQDY0101", instr.getLocation(), false);
        methodInfo.placeLabel(nameOK);
    }

    @Override
    protected void pushNode(CompilerService compiler, Expression expression) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo xmlTestOk = methodInfo.newLabel("xmltestok");
        LabelInfo xmlnsOk = methodInfo.newLabel("xmlnsOk");
        LabelInfo validURI = methodInfo.newLabel("validURI");
        ga.dup2();
        ga.dup();
        ga.invokeInstanceMethod(CharSequence.class, "length", new Class[0]);
        LabelInfo nonEmpty = methodInfo.newLabel("nonEmptyUri");
        ga.ifZCmp(154, nonEmpty.label());
        compiler.generateDynamicError("Namespace URI must not be zero-length", ((Instruction)expression).isXSLT() ? "XTDE0930" : "XQDY0101", expression.getLocation(), false);
        methodInfo.placeLabel(nonEmpty);
        ga.push("http://www.w3.org/XML/1998/namespace");
        ga.invokeInstanceMethod(Object.class, "equals", Object.class);
        ga.swap();
        ga.push("xml");
        ga.invokeInstanceMethod(Object.class, "equals", Object.class);
        ga.ifICmp(153, xmlTestOk.label());
        compiler.generateDynamicError("Namespace prefix 'xml' and namespace uri http://www.w3.org/XML/1998/namespace must only be used together", ((Instruction)expression).isXSLT() ? "XTDE0925" : "XQDY0101", expression.getLocation(), false);
        methodInfo.placeLabel(xmlTestOk);
        ga.dup();
        ga.push("http://www.w3.org/2000/xmlns/");
        ga.invokeInstanceMethod(Object.class, "equals", Object.class);
        ga.ifFalse(xmlnsOk);
        compiler.generateDynamicError("Namespace URI must not be http://www.w3.org/2000/xmlns/", ((Instruction)expression).isXSLT() ? "XTDE0905" : "XQDY0101", expression.getLocation(), false);
        methodInfo.placeLabel(xmlnsOk);
        if (compiler.getConfiguration().getXsdVersion() == 10) {
            ga.dup();
            ga.invokeStaticMethod(StandardURIChecker.class, "getInstance", new Class[0]);
            ga.swap();
            ga.invokeInstanceMethod(StandardURIChecker.class, "isValidURI", CharSequence.class);
            ga.ifTrue(validURI);
            compiler.generateDynamicError("The string value of the constructed namespace node must be a valid URI", "XTDE0905", expression.getLocation(), false);
            methodInfo.placeLabel(validURI);
        }
        ga.invokeStaticMethod(NamespaceBinding.class, "makeNamespaceBinding", CharSequence.class, CharSequence.class);
        ga.push(32);
        ga.invokeInstanceMethod(Receiver.class, "namespace", NamespaceBindingSet.class, Integer.TYPE);
    }
}

