/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.AttributeGroupReference;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.XSDAnyAttribute;
import com.saxonica.ee.schema.sdoc.XSDAttribute;
import com.saxonica.ee.schema.sdoc.XSDRedefine;
import java.util.List;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;

public class XSDAttributeGroup
extends SchemaElement {
    private boolean isRedefinition;
    private AttributeGroupDecl attributeGroupDecl = null;
    private AttributeGroupReference attributeGroupReference = null;
    private boolean isRef = false;
    private static final int[] state0terms = new int[]{580, 584, 585, 578};
    private static final int[] state0targets = new int[]{1, 2, 2, 3};
    private static final int[] state1terms = new int[0];
    private static final int[] state1targets = new int[0];
    private static final int[] state2terms = new int[]{580, 584, 585};
    private static final int[] state2targets = new int[]{1, 2, 2};
    private static final int[] state3terms = new int[]{580, 584, 585};
    private static final int[] state3targets = new int[]{1, 2, 2};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets};

    @Override
    public void prepareAttributes() throws SchemaException {
        this.isRedefinition = this.getParent() instanceof XSDRedefine;
        AttributeCollection atts = this.getAttributeList();
        if (this.isTopLevel()) {
            StructuredQName nc;
            String[] allowed = new String[]{"id", "name"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "name");
            String qname = atts.getValue("", "name");
            if (qname == null) {
                return;
            }
            try {
                nc = this.getComponentName(qname, 1);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            this.attributeGroupDecl = new AttributeGroupDecl((EnterpriseConfiguration)this.getConfiguration());
            this.attributeGroupDecl.setLocator(this);
            this.attributeGroupDecl.setAttributeGroupName(nc);
            this.attributeGroupDecl.setSchemaDocumentURI(this.getParent().getSystemId());
        } else {
            StructuredQName fp;
            String[] allowed = new String[]{"id", "ref"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "ref");
            String ref = atts.getValue("", "ref");
            if (ref == null) {
                return;
            }
            try {
                fp = this.getComponentName(ref, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            this.isRef = true;
            this.attributeGroupReference = new AttributeGroupReference((EnterpriseConfiguration)this.getConfiguration(), fp);
            this.attributeGroupReference.setLocator(this);
        }
        this.processId();
    }

    public boolean isReference() {
        return this.isRef;
    }

    public AttributeGroupDecl getAttributeGroupDecl() {
        return this.attributeGroupDecl;
    }

    public AttributeGroupReference getAttributeGroupReference() {
        return this.attributeGroupReference;
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        if (this.isRef) {
            this.checkOnlyChildIsAnnotation();
        } else {
            this.checkContentModel(stateTerms, stateTargets, false);
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return true;
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = iter.next()) != null) {
            String name = child.getLocalPart();
            if ("anyAttribute".equals(name)) {
                AttributeWildcard wildcard = ((XSDAnyAttribute)child).getWildcard();
                if (this.attributeGroupDecl == null) continue;
                this.attributeGroupDecl.setAnyAttribute(wildcard);
                continue;
            }
            if ("attribute".equals(name)) {
                AttributeUse attributeUse = ((XSDAttribute)child).getAttributeUse();
                if (this.attributeGroupDecl == null || attributeUse == null) continue;
                attributeUse.setContainingAttributeGroupDecl(this.attributeGroupDecl);
                if (attributeUse.isProhibited()) {
                    compiler.warning("Specifying use='prohibited' within an attribute group has no effect", this);
                    continue;
                }
                this.attributeGroupDecl.addAttributeUse(attributeUse);
                continue;
            }
            if ("attributeGroup".equals(name)) {
                AttributeGroupReference obj = ((XSDAttributeGroup)child).getAttributeGroupReference();
                if (this.attributeGroupDecl == null) continue;
                this.attributeGroupDecl.addAttributeGroupReference(obj);
                continue;
            }
            if (!"annotation".equals(name)) continue;
        }
        if (this.isRedefinition) {
            AttributeGroupDecl found;
            SingleNamespaceSchema externalSchema = ((XSDRedefine)this.getParent()).getExternalSchema();
            SingleNamespaceSchema redefinedSchema = ((XSDRedefine)this.getParent()).getRedefinedSchema();
            if (externalSchema == null || redefinedSchema == null) {
                return;
            }
            EnterpriseConfiguration config = this.getSchema().getConfiguration();
            if (config.isSealedNamespace(redefinedSchema.getTargetNamespace())) {
                this.error("It is not possible to redefine schema components in namespace " + redefinedSchema.getTargetNamespace() + " because components in this namespace have already been used  for validating instance documents, or for compiling queries or stylesheets");
                return;
            }
            if (this.isRef) {
                this.error("An attribute group redefinition must not be a reference");
            }
            if ((found = this.patchUpSelfReferences(this.attributeGroupDecl.getLocalAttributeGroupReferences(), this.attributeGroupDecl.getAttributeGroupName(), null, compiler)) != null) {
                this.attributeGroupDecl.setRedefinitionLevel(found.getRedefinitionLevel() + 1);
                this.checkImmediateRedefinition(found, compiler);
            } else {
                AttributeGroupDecl d = externalSchema.getAttributeGroup(this.attributeGroupDecl.getAttributeGroupName());
                if (d == null) {
                    this.error("Attribute group " + Err.wrap(this.attributeGroupDecl.getDisplayName()) + " is not defined in the schema being redefined");
                    return;
                }
                this.attributeGroupDecl.setRedefinedAttributeGroupDecl(d);
                this.attributeGroupDecl.setRedefinitionLevel(d.getRedefinitionLevel() + 1);
            }
            redefinedSchema.addAttributeGroup(this.attributeGroupDecl);
        }
    }

    private AttributeGroupDecl patchUpSelfReferences(List<AttributeGroupReference> references, StructuredQName name, AttributeGroupDecl found, SchemaCompiler compiler) throws SchemaException {
        SingleNamespaceSchema containingSchema = this.getSchema();
        SingleNamespaceSchema redefinedSchema = ((XSDRedefine)this.getParent()).getRedefinedSchema();
        SingleNamespaceSchema externalSchema = ((XSDRedefine)this.getParent()).getExternalSchema();
        AttributeGroupDecl f = found;
        for (AttributeGroupReference ref : references) {
            if (!ref.getTargetComponentName().equals(name)) continue;
            if (f != null) {
                this.error("Redefined attribute group " + Err.wrap(name.getDisplayName()) + " contains more than one reference to itself");
            }
            String uri = this.getXSDSchema().getTargetNamespace();
            String localName = ref.getTargetComponentName().getLocalPart();
            String newLocalName = localName + '_' + ref.hashCode();
            StructuredQName newNameCode = new StructuredQName("", uri, newLocalName);
            f = externalSchema.getAttributeGroup(name);
            if (f == null) {
                this.error("Attribute group " + Err.wrap(name.getDisplayName()) + " is not defined in the schema being redefined");
                return null;
            }
            this.checkImmediateRedefinition(f, compiler);
            ref.setTargetComponentName(newNameCode);
            f.setAttributeGroupName(newNameCode);
            redefinedSchema.addAttributeGroup(f);
            f = this.patchUpSelfReferences(f.getLocalAttributeGroupReferences(), name, f, compiler);
        }
        return f;
    }

    private void checkImmediateRedefinition(AttributeGroupDecl f, SchemaCompiler compiler) {
        if (!((XSDRedefine)this.getParent()).getExternalSchemaDocumentURI().equals(f.getSchemaDocumentURI())) {
            compiler.warning("The redefined attribute group was found, but not in the schema document referenced by the schemaLocation attribute of the containing <xs:redefine> element. This is not allowed by the XSD specification. However, Saxon does not currently enforce this rule.", this);
        }
    }
}

