/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.lemmatizer.LemmaSampleEventStream;
import opennlp.tools.lemmatizer.LemmaSampleSequenceStream;
import opennlp.tools.lemmatizer.Lemmatizer;
import opennlp.tools.lemmatizer.LemmatizerContextGenerator;
import opennlp.tools.lemmatizer.LemmatizerFactory;
import opennlp.tools.lemmatizer.LemmatizerModel;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.EventModelSequenceTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.StringUtil;
import opennlp.tools.util.TrainingParameters;

public class LemmatizerME
implements Lemmatizer {
    public static final int LEMMA_NUMBER = 29;
    public static final int DEFAULT_BEAM_SIZE = 3;
    protected int beamSize;
    private Sequence bestSequence;
    private final SequenceClassificationModel<String> model;
    private final LemmatizerContextGenerator contextGenerator;
    private final SequenceValidator<String> sequenceValidator;

    public LemmatizerME(LemmatizerModel model) {
        LemmatizerFactory factory = model.getFactory();
        int defaultBeamSize = 3;
        String beamSizeString = model.getManifestProperty("BeamSize");
        if (beamSizeString != null) {
            defaultBeamSize = Integer.parseInt(beamSizeString);
        }
        this.contextGenerator = factory.getContextGenerator();
        this.beamSize = defaultBeamSize;
        this.sequenceValidator = factory.getSequenceValidator();
        this.model = model.getLemmatizerSequenceModel() != null ? model.getLemmatizerSequenceModel() : new BeamSearch<String>(this.beamSize, (MaxentModel)((Object)model.getLemmatizerSequenceModel()), 0);
    }

    @Override
    public String[] lemmatize(String[] toks, String[] tags) {
        String[] ses = this.predictSES(toks, tags);
        return LemmatizerME.decodeLemmas(toks, ses);
    }

    @Override
    public List<List<String>> lemmatize(List<String> toks, List<String> tags) {
        String[] tokens = toks.toArray(new String[0]);
        String[] posTags = tags.toArray(new String[0]);
        String[][] allLemmas = this.predictLemmas(29, tokens, posTags);
        ArrayList<List<String>> predictedLemmas = new ArrayList<List<String>>();
        for (String[] allLemma : allLemmas) {
            predictedLemmas.add(Arrays.asList(allLemma));
        }
        return predictedLemmas;
    }

    public String[] predictSES(String[] toks, String[] tags) {
        this.bestSequence = this.model.bestSequence((String[])toks, new Object[]{tags}, this.contextGenerator, this.sequenceValidator);
        List<String> ses = this.bestSequence.getOutcomes();
        return ses.toArray(new String[0]);
    }

    public String[][] predictLemmas(int numLemmas, String[] toks, String[] tags) {
        Sequence[] bestSequences = this.model.bestSequences(numLemmas, (String[])toks, new Object[]{tags}, this.contextGenerator, this.sequenceValidator);
        String[][] allLemmas = new String[bestSequences.length][];
        for (int i = 0; i < allLemmas.length; ++i) {
            List<String> ses = bestSequences[i].getOutcomes();
            String[] sesArray = ses.toArray(new String[0]);
            allLemmas[i] = LemmatizerME.decodeLemmas(toks, sesArray);
        }
        return allLemmas;
    }

    public static String[] decodeLemmas(String[] toks, String[] preds) {
        ArrayList<String> lemmas = new ArrayList<String>();
        for (int i = 0; i < toks.length; ++i) {
            String lemma = StringUtil.decodeShortestEditScript(toks[i].toLowerCase(), preds[i]);
            if (lemma.length() == 0) {
                lemma = "_";
            }
            lemmas.add(lemma);
        }
        return lemmas.toArray(new String[0]);
    }

    public static String[] encodeLemmas(String[] toks, String[] lemmas) {
        ArrayList<String> sesList = new ArrayList<String>();
        for (int i = 0; i < toks.length; ++i) {
            String ses = StringUtil.getShortestEditScript(toks[i], lemmas[i]);
            if (ses.length() == 0) {
                ses = "_";
            }
            sesList.add(ses);
        }
        return sesList.toArray(new String[0]);
    }

    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        return this.model.bestSequences(3, (String[])sentence, new Object[]{tags}, this.contextGenerator, this.sequenceValidator);
    }

    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        return this.model.bestSequences(3, (String[])sentence, new Object[]{tags}, minSequenceScore, this.contextGenerator, this.sequenceValidator);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static LemmatizerModel train(String languageCode, ObjectStream<LemmaSample> samples, TrainingParameters params, LemmatizerFactory factory) throws IOException {
        LemmatizerContextGenerator contextGenerator = factory.getContextGenerator();
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(params);
        MaxentModel lemmatizerModel = null;
        SequenceClassificationModel<String> seqLemmatizerModel = null;
        if (TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)trainerType)) {
            LemmaSampleEventStream es = new LemmaSampleEventStream(samples, contextGenerator);
            EventTrainer trainer = TrainerFactory.getEventTrainer(params, manifestInfoEntries);
            lemmatizerModel = trainer.train(es);
        } else if (TrainerFactory.TrainerType.EVENT_MODEL_SEQUENCE_TRAINER.equals((Object)trainerType)) {
            LemmaSampleSequenceStream ss = new LemmaSampleSequenceStream(samples, contextGenerator);
            EventModelSequenceTrainer<LemmaSample> trainer = TrainerFactory.getEventModelSequenceTrainer(params, manifestInfoEntries);
            lemmatizerModel = trainer.train(ss);
        } else if (TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceTrainer trainer = TrainerFactory.getSequenceModelTrainer(params, manifestInfoEntries);
            LemmaSampleSequenceStream ss = new LemmaSampleSequenceStream(samples, contextGenerator);
            seqLemmatizerModel = trainer.train(ss);
        } else {
            throw new IllegalArgumentException("Trainer type is not supported: " + trainerType);
        }
        int beamSize = params.getIntParameter("BeamSize", 3);
        if (lemmatizerModel != null) {
            return new LemmatizerModel(languageCode, lemmatizerModel, beamSize, manifestInfoEntries, factory);
        }
        return new LemmatizerModel(languageCode, seqLemmatizerModel, manifestInfoEntries, factory);
    }

    public Sequence[] topKLemmaClasses(String[] sentence, String[] tags) {
        return this.model.bestSequences(3, (String[])sentence, new Object[]{tags}, this.contextGenerator, this.sequenceValidator);
    }

    public Sequence[] topKLemmaClasses(String[] sentence, String[] tags, double minSequenceScore) {
        return this.model.bestSequences(3, (String[])sentence, new Object[]{tags}, minSequenceScore, this.contextGenerator, this.sequenceValidator);
    }
}

