/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.jaxp;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ResourceResolverWrappingLSResourceResolver
implements ResourceResolver {
    private final LSResourceResolver resolver;

    public ResourceResolverWrappingLSResourceResolver(LSResourceResolver resolver) {
        this.resolver = resolver;
    }

    public LSResourceResolver getLSResourceResolver() {
        return this.resolver;
    }

    @Override
    public Source resolve(ResourceRequest request) throws XPathException {
        LSInput lsin;
        String type = request.nature;
        if (request.nature.equals("https://www.iana.org/assignments/media-types/application/xml")) {
            type = "http://www.w3.org/XML/1998/namespace";
        }
        if ((lsin = this.resolver.resolveResource(type, request.publicId, request.uriIsNamespace ? request.uri : null, request.relativeUri, request.baseUri)) == null) {
            return null;
        }
        Reader reader = lsin.getCharacterStream();
        InputStream stream = lsin.getByteStream();
        String content = lsin.getStringData();
        String systemId = lsin.getSystemId();
        String publicId = lsin.getPublicId();
        if (content != null) {
            reader = new StringReader(content);
        }
        StreamSource source = new StreamSource();
        source.setSystemId(systemId);
        source.setPublicId(publicId);
        source.setReader(reader);
        source.setInputStream(stream);
        return source;
    }
}

