/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.TypeAlternative;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.validate.AllElementValidator;
import com.saxonica.ee.validate.AnyTypeValidator;
import com.saxonica.ee.validate.ComplexContentValidator;
import com.saxonica.ee.validate.EmptyContentValidator;
import com.saxonica.ee.validate.LaxValidator;
import com.saxonica.ee.validate.SimpleContentValidator;
import com.saxonica.ee.validate.SkipValidator;
import com.saxonica.ee.validate.StartTagBufferEE;
import com.saxonica.ee.validate.ValidatingFilter;
import com.saxonica.ee.validate.ValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.type.ValidationParams;

public abstract class ContentValidator
extends ValidatingFilter {
    protected ContentValidator childValidator;
    private StructuredQName containingElement = null;
    private Location containingElementLocation;
    protected boolean nil = false;
    private Nillability nillability = Nillability.IGNORED;
    private ElementDecl elementDecl;
    private SchemaType annotation = Untyped.getInstance();
    protected List<String> pendingMessages;

    public ContentValidator(Receiver next) {
        super(next);
    }

    public void setContainingElement(StructuredQName name, Location locationId) {
        this.containingElement = name;
        this.containingElementLocation = locationId;
    }

    protected void setElementDeclaration(ElementDecl decl) {
        this.elementDecl = decl;
    }

    protected ElementDecl getElementDeclaration() {
        return this.elementDecl;
    }

    public StructuredQName getContainingElement() {
        return this.containingElement;
    }

    public Location getContainingElementLocationId() {
        return this.containingElementLocation;
    }

    protected String getContainingElementName() {
        StructuredQName nn = this.getContainingElement();
        if (nn == null) {
            return "element";
        }
        return "element " + Err.wrap(nn.getDisplayName(), 1);
    }

    public abstract SchemaType getSchemaType();

    protected final void setAnnotation(SchemaType annotation) {
        this.annotation = annotation;
    }

    protected final SchemaType getAnnotation() {
        return this.annotation;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getStartTagBuffer();
    }

    public void setNillability(Nillability nillability) {
        this.nillability = nillability;
    }

    public Nillability getNillability() {
        return this.nillability;
    }

    public boolean isNil() {
        return this.nil;
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        ElementDecl element;
        if (this.getConstraintChecker() != null && (element = this.getChildValidator().getElementDeclaration()) != null) {
            this.getConstraintChecker().setElementDeclaration(element);
        }
        try {
            this.nextReceiver.startElement(nameCode, typeCode, location, properties);
        }
        catch (ValidationException ve) {
            this.reportValidationError(ve.getValidationFailure(), true, location);
        }
    }

    public static ContentValidator makeValidator(ElementDecl decl, StructuredQName elementName, Location locationId, ValidationContext validationContext, SchemaType governingType, int validation, PipelineConfiguration pipe, Receiver nextReceiver, List<ValidationFailure> failures) throws MissingComponentException {
        ContentValidator val;
        Configuration config = pipe.getConfiguration();
        Nillability nillability = Nillability.IGNORED;
        if (validation == 4 && governingType == null) {
            val = new SkipValidator(nextReceiver);
        } else if (validation == 8) {
            val = ContentValidator.makeValidatorForType(null, governingType, pipe, nextReceiver, failures);
            if (!failures.isEmpty()) {
                return null;
            }
        } else if (decl == null) {
            if (governingType != null) {
                val = ContentValidator.makeValidatorForType(null, governingType, pipe, nextReceiver, failures);
                if (!failures.isEmpty()) {
                    return null;
                }
            } else {
                if (validation == 1) {
                    String message = "Cannot validate " + Err.wrap(elementName.getStructuredQName().getEQName(), 1) + ": no element declaration available";
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-elt", "1");
                    if (pipe.getHostLanguage() == 50) {
                        ve.setErrorCode("XTTE1512");
                    } else {
                        ve.setErrorCode("XQDY0084");
                    }
                    failures.add(ve);
                    return null;
                }
                val = new LaxValidator(nextReceiver);
                val.setUnderlyingReceiver(nextReceiver);
            }
        } else {
            if (decl.isAbstract()) {
                String msg = "Invalid element " + Err.wrap(elementName.getDisplayName(), 1) + ": the element is declared to be abstract";
                ValidationFailure ve = new ValidationFailure(msg);
                failures.add(ve);
                return null;
            }
            nillability = decl.isNillable() ? Nillability.ALLOWED : Nillability.DISALLOWED;
            config.sealNamespace(decl.getTargetNamespace());
            if (governingType != null && governingType.getFingerprint() == 631) {
                ValidationFailure ve = new ValidationFailure("Cannot use xs:untypedAtomic as governing type for validation");
                failures.add(ve);
                return null;
            }
            SchemaType elType = decl.getType();
            StartTagBufferEE startTagBuffer = validationContext.getStartTagBuffer();
            if (startTagBuffer != null && decl.hasTypeAlternatives()) {
                try {
                    elType = ContentValidator.getConditionalType(validationContext, decl);
                }
                catch (XPathException e) {
                    ValidationFailure ve = new ValidationFailure("Failure during conditional type assignment: " + e.getMessage());
                    failures.add(ve);
                    return null;
                }
            }
            if (elType != null && governingType != null) {
                int block = decl.getBlock() | elType.getBlock();
                try {
                    config.checkTypeDerivationIsOK(governingType, elType, block);
                }
                catch (SchemaException err) {
                    ValidationFailure ve = new ValidationFailure("The xsi:type is not validly derived from the declared type. " + err.getMessage());
                    ve.setConstraintReference(1, "cvc-elt", "4.3");
                    failures.add(ve);
                    return null;
                }
                elType = governingType;
            }
            if (elType == null) {
                if (governingType == null) {
                    val = new AnyTypeValidator(nextReceiver);
                } else {
                    val = ContentValidator.makeValidatorForType(decl, governingType, pipe, nextReceiver, failures);
                    if (!failures.isEmpty()) {
                        return null;
                    }
                }
            } else if (elType instanceof UserComplexType && ((ComplexType)elType).isAbstract()) {
                if (governingType == null) {
                    ValidationFailure ve = new ValidationFailure("Cannot validate content against an abstract type");
                    ve.setConstraintReference(1, "cvc-complex-type", "1");
                    failures.add(ve);
                    return null;
                }
                val = ContentValidator.makeValidatorForType(decl, governingType, pipe, nextReceiver, failures);
                if (!failures.isEmpty()) {
                    return null;
                }
            } else {
                governingType = elType;
                val = ContentValidator.makeValidatorForType(decl, elType, pipe, nextReceiver, failures);
                if (!failures.isEmpty()) {
                    return null;
                }
            }
        }
        assert (val != null);
        val.setPipelineConfiguration(pipe);
        val.setContainingElement(elementName.getStructuredQName(), locationId);
        val.setValidationContext(validationContext);
        val.setNillability(nillability);
        val.setElementDeclaration(decl);
        val.setAnnotation(governingType == null ? Untyped.getInstance() : governingType);
        return val;
    }

    private static SchemaType getConditionalType(ValidationContext validationContext, ElementDecl decl) throws XPathException {
        StartTagBufferEE startTagBuffer = validationContext.getStartTagBuffer();
        SchemaType eltype = decl.getType();
        NodeInfo element = startTagBuffer.createSkeletonElementNode();
        for (TypeAlternative alt : decl.getTypeAlternatives()) {
            XPathExpression exp = alt.getCondition();
            if (exp == null) {
                eltype = alt.getSchemaType();
                break;
            }
            Controller controller = validationContext.getController();
            XPathDynamicContext context = exp.createDynamicContext(controller, element);
            Assertion.setDocumentsAndCollections(controller.getConfiguration(), context);
            ValidationParams actualParams = startTagBuffer.getPipelineConfiguration().getParseOptions().getValidationParams();
            Map<StructuredQName, XPathVariable> declaredParams = alt.getParameters();
            ValidationParams.setValidationParams(declaredParams, actualParams, context);
            try {
                if (!ExpressionTool.effectiveBooleanValue(exp.iterate(context))) continue;
                eltype = alt.getSchemaType();
                break;
            }
            catch (XPathException err) {
                PipelineConfiguration pipe = startTagBuffer.getPipelineConfiguration();
                XPathException warning = new XPathException("Dynamic error occurred during evaluation of Conditional Type Alternative test: " + err.getMessage(), err);
                pipe.getErrorListener().warning(warning);
            }
        }
        return eltype;
    }

    protected abstract ContentValidator getChildValidator();

    public static ContentValidator makeValidatorForType(ElementDecl elementDecl, SchemaType schemaType, PipelineConfiguration pipe, Receiver nextReceiver, List<ValidationFailure> failures) throws MissingComponentException {
        ContentValidator val;
        if (schemaType instanceof SimpleType) {
            val = new SimpleContentValidator(elementDecl, schemaType, nextReceiver);
        } else if (schemaType instanceof AnyType) {
            val = new AnyTypeValidator(elementDecl, nextReceiver);
        } else {
            if (schemaType.getFingerprint() == 631) {
                ValidationFailure ve = new ValidationFailure("Cannot use xs:untypedAtomic as governing type for validation");
                failures.add(ve);
                return null;
            }
            ComplexType complexType = (ComplexType)schemaType;
            if (complexType.isSimpleContent()) {
                val = new SimpleContentValidator(elementDecl, complexType, nextReceiver);
            } else {
                if (complexType.isAbstract()) {
                    ValidationFailure ve = new ValidationFailure("Cannot validate content against an abstract type");
                    ve.setConstraintReference(1, "cvc-complex-type", "1");
                    failures.add(ve);
                    return null;
                }
                val = complexType.isEmptyContent() ? new EmptyContentValidator((UserComplexType)complexType, nextReceiver) : (complexType.isAllContent() ? new AllElementValidator((UserComplexType)complexType, nextReceiver) : new ComplexContentValidator(elementDecl, (UserComplexType)complexType, nextReceiver));
            }
        }
        return val;
    }

    @Override
    public void endDocument() throws XPathException {
        this.reportIfInvalid();
        this.nextReceiver.endDocument();
    }

    protected void makeChildValidator(ElementDecl decl, StructuredQName elementName, Location locationId, int process) throws XPathException {
        ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>();
        this.childValidator = ContentValidator.makeValidator(decl, elementName, locationId, this.getValidationContext(), this.getValidationContext().getXSIType(), process, this.getPipelineConfiguration(), this.getNextReceiver(), failures);
        for (ValidationFailure failure : failures) {
            this.reportValidationError(failure, false, locationId);
            if (this.childValidator != null) continue;
            this.childValidator = new SkipValidator(this.getNextReceiver());
            this.childValidator.setValidationContext(this.getValidationContext());
        }
        if (this.childValidator != null) {
            this.childValidator.setConstraintChecker(this.getConstraintChecker());
        }
    }

    protected void checkNoChildrenWhenNil(Location location) throws XPathException {
        if (this.nil) {
            this.reportContentWhenNil("No child elements are allowed when xsi:nil is true", location);
        }
    }

    protected void checkNoCharactersWhenNil(Location location) throws XPathException {
        if (this.nil) {
            this.reportContentWhenNil("No character content is allowed when xsi:nil is true", location);
        }
    }

    private void reportContentWhenNil(String message, Location location) throws XPathException {
        ValidationFailure ve = new ValidationFailure(message);
        ve.setConstraintReference(1, "cvc-elt", "3.2.1");
        ve.setSchemaType(this.getSchemaType());
        this.reportValidationError(ve, true, location);
    }

    public static enum Nillability {
        IGNORED,
        ALLOWED,
        DISALLOWED;

    }
}

