/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.JavaVerifier;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.z.IntHashMap;

public abstract class Verifier {
    private static final boolean DISABLED = false;
    private static final int MS_A_DAY = 86400000;
    private License primaryLicense = null;
    private final IntHashMap<License> secondaryLicenses = new IntHashMap();
    protected int status = 0;
    private static final int UNREAD = 0;
    private static final int AVAILABLE = 1;
    private static final int UNAVAILABLE = 2;
    protected static final String LICENSE_FILE_NAME = "saxon-license.lic";

    Verifier() {
    }

    protected void setPrimaryLicense(License license) {
        this.primaryLicense = license;
    }

    protected License getPrimaryLicense() {
        return this.primaryLicense;
    }

    void displayLicenseMessage(Configuration config) {
        this.loadPrimaryLicense(config);
        if (config.isTiming()) {
            config.getLogger().info("Using license serial number " + this.getSerialNumber());
        }
        if (!config.getConfigurationProperty(Feature.SUPPRESS_EVALUATION_EXPIRY_WARNING).booleanValue()) {
            int left = this.primaryLicense.daysLeft();
            if (left == 1) {
                config.getLogger().info("****** Saxon license expires tomorrow! ******");
            } else if (left > 0 && left < 30) {
                config.getLogger().info("Saxon license expires in " + left + " days");
            }
        }
    }

    public String getFeature(String name, Configuration config) {
        this.loadPrimaryLicense(config);
        return this.primaryLicense.getFeature(name);
    }

    public Properties getLicenseFeatures(Configuration config) {
        this.loadPrimaryLicense(config);
        return this.primaryLicense.getProperties();
    }

    final void loadPrimaryLicense(Configuration config) {
        if (this.status == 2) {
            throw new LicenseException("Saxon license disabled", 3);
        }
        if (this.status == 0) {
            try {
                this.loadLicense(config);
                this.status = 1;
            }
            catch (LicenseException e) {
                this.primaryLicense = null;
                this.status = 2;
                throw e;
            }
        }
    }

    protected abstract void loadLicense(Configuration var1);

    synchronized void loadLicense(String filename) {
        boolean exists = false;
        try {
            InputStream is;
            if (filename.startsWith("file:")) {
                is = this.connectToURI(filename);
            } else {
                exists = new File(filename).exists();
                is = new FileInputStream(filename);
            }
            this.primaryLicense = this.readLicenseFile(is);
            this.status = 1;
            is.close();
        }
        catch (IOException e) {
            this.primaryLicense = null;
            this.status = 2;
            throw new LicenseException("Failed to read license file " + filename, exists ? 3 : 5);
        }
    }

    protected InputStream connectToURI(String uri) throws IOException {
        return new URL(uri).openStream();
    }

    synchronized int registerSecondaryLicense(String dmk) {
        try {
            Base64BinaryValue b64 = new Base64BinaryValue(StringView.of(dmk).tidy());
            byte[] binary = b64.getBinaryValue();
            ByteArrayInputStream is = new ByteArrayInputStream(binary);
            License license = this.configure(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8), true);
            int id = dmk.hashCode() & 0x3FFFF;
            while (this.secondaryLicenses.get(id) != null) {
                ++id;
            }
            this.secondaryLicenses.put(id, license);
            return id;
        }
        catch (XPathException err) {
            throw new LicenseException(err.getMessage(), 2);
        }
    }

    void disableLicensing() {
        this.primaryLicense = null;
        this.status = 2;
    }

    synchronized boolean isFeatureAllowedBySecondaryLicense(int license, int feature) {
        License lic = this.secondaryLicenses.get(license);
        if (lic == null) {
            return false;
        }
        switch (feature) {
            case 8: {
                return true;
            }
            case 2: {
                return "yes".equals(lic.getFeature("SAT"));
            }
            case 4: {
                return "yes".equals(lic.getFeature("SAQ"));
            }
            case 1: {
                return "yes".equals(lic.getFeature("SAV"));
            }
        }
        return false;
    }

    protected License readLicenseFile(InputStream is) {
        return this.configure(new InputStreamReader(is, StandardCharsets.UTF_8), false);
    }

    synchronized void supplyLicenseKey(Reader reader) {
        License license = this.configure(reader, false);
        String value = license.getFeature("Company");
        if (value == null || !value.startsWith("OEM")) {
            this.primaryLicense = null;
            this.status = 2;
            throw new IllegalArgumentException("License key supplied is not a valid OEM license key");
        }
        this.primaryLicense = license;
        this.status = 1;
    }

    private License configure(Reader reader, boolean embedded) {
        License license;
        Reader lineReader = this.makeLineReader(reader);
        try {
            DayTimeDurationValue sinceMinorRelease;
            DayTimeDurationValue sinceMajorRelease;
            String licenseDesc;
            String line;
            StringBuilder buffer = new StringBuilder(80);
            Properties features = new Properties();
            license = new License(features);
            String signature = "";
            while ((line = Verifier.readLine(lineReader)) != null) {
                String value;
                String name;
                if (line.trim().indexOf(35) == 0 || line.trim().indexOf(33) == 0) continue;
                int index = line.indexOf(61);
                if (index > 0) {
                    name = line.substring(0, index).trim();
                    value = line.substring(++index).trim();
                } else {
                    name = line.trim();
                    value = "";
                }
                if ("".equals(name)) continue;
                features.setProperty(name, value);
                if ("Signature".equals(name)) {
                    signature = value;
                    continue;
                }
                buffer.append(name).append('=').append(value).append('\n');
            }
            boolean valid = this.verify(buffer.toString(), signature);
            String string = licenseDesc = embedded ? "embedded license" : "license file";
            if (!valid) {
                throw new LicenseException("Invalid " + licenseDesc + " found", 2);
            }
            String serial = license.getFeature("Serial");
            licenseDesc = licenseDesc + " (serial number " + serial + ")";
            int daysLeft = license.daysLeft();
            if (daysLeft < 0) {
                if ("yes".equals(features.getProperty("Evaluation")) || daysLeft < -45) {
                    license.clearFeatures();
                    throw new LicenseException("The " + licenseDesc + " has expired", 1);
                }
                if (daysLeft < -15) {
                    System.err.println("Saxon " + licenseDesc + " has expired. \n*** You are using the software without lawful authority. ***\nYou must obtain a new license immediately; meanwhile a delay of " + Math.abs(daysLeft) * 2 + " seconds will be imposed. This delay will increase every day.");
                    try {
                        Thread.sleep(Math.abs(daysLeft) * 2000);
                    }
                    catch (InterruptedException e) {
                        throw new LicenseException("Saxon license " + licenseDesc + " has expired", 1);
                    }
                } else {
                    System.err.println("Saxon " + licenseDesc + " has expired. \n*** You are using the software without lawful authority. ***\nYou must obtain a new license immediately.");
                }
            }
            DateValue licenseIssued = new DateValue(BMPString.of(features.getProperty("Issued").substring(0, 10) + 'Z'));
            DateValue majorVersionIssued = new DateValue(BMPString.of(Version.getMajorReleaseDate() + 'Z'));
            String upgradeDays = features.getProperty("UpgradeDays");
            int udays = 366;
            if (upgradeDays != null) {
                udays = Integer.parseInt(upgradeDays.trim());
            }
            if ((sinceMajorRelease = majorVersionIssued.subtract(licenseIssued, null)).getLengthInSeconds() > (double)(86400 * udays)) {
                throw new LicenseException("The " + licenseDesc + " does not cover upgrade to this Saxon version", 1);
            }
            DateValue minorVersionIssued = new DateValue(BMPString.of(Version.getReleaseDate() + 'Z'));
            String maintenanceDays = features.getProperty("MaintenanceDays");
            int mdays = udays;
            if (maintenanceDays != null) {
                mdays = Integer.parseInt(maintenanceDays.trim());
            }
            if ((sinceMinorRelease = minorVersionIssued.subtract(licenseIssued, null)).getLengthInSeconds() > (double)(86400 * mdays)) {
                throw new LicenseException("The " + licenseDesc + " does not cover this Saxon maintenance release", 1);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException("License file uses windows-1252, which is an unsupported encoding", 2);
        }
        catch (IOException e) {
            throw new LicenseException(e.getMessage(), 3);
        }
        catch (XPathException e) {
            throw new LicenseException("Invalid date in license file", 2);
        }
        return license;
    }

    private Reader makeLineReader(Reader reader) {
        return new BufferedReader(reader);
    }

    private static String readLine(Reader reader) throws IOException {
        return ((BufferedReader)reader).readLine();
    }

    String getSerialNumber() {
        return this.primaryLicense.getFeature("Serial");
    }

    protected static byte[] convertHexToBinary(String hex) {
        int len = hex.length() / 2;
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c1 = hex.charAt(i * 2);
            char c2 = hex.charAt(i * 2 + 1);
            if (c1 >= '0' && c1 <= '9') {
                out[i] = (byte)((c1 - 48) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                out[i] = (byte)((c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException();
            }
            if (c2 >= '0' && c2 <= '9') {
                int n = i;
                out[n] = (byte)(out[n] + (c2 - 48));
                continue;
            }
            if (c2 >= 'A' && c2 <= 'F') {
                int n = i;
                out[n] = (byte)(out[n] + (c2 - 65 + 10));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return out;
    }

    protected abstract boolean verify(String var1, String var2) throws LicenseException;

    public static void main(String[] args) throws Exception {
        File licenseFile = new File(args[0]);
        JavaVerifier v = new JavaVerifier();
        License license = v.readLicenseFile(new FileInputStream(licenseFile));
        System.err.println("License OK");
        Enumeration<?> en = license.features.propertyNames();
        while (en.hasMoreElements()) {
            String s = (String)en.nextElement();
            System.err.println("Feature " + s + " = " + license.features.getProperty(s));
        }
    }

    protected static class License {
        protected final Properties features;

        public License(Properties features) {
            this.features = features;
        }

        int daysLeft() {
            String company = this.features.getProperty("Company");
            if (company != null && company.startsWith("OEM")) {
                return 0;
            }
            String expiration = this.features.getProperty("Expiration");
            if (expiration == null) {
                return -1;
            }
            if (expiration.trim().isEmpty() || expiration.contains("never")) {
                return 0;
            }
            try {
                String evaluating = this.features.getProperty("Evaluation");
                DateValue expiryDate = new DateValue(BMPString.of(expiration));
                long expiryTimeMillis = expiryDate.toDateTime().secondsSinceEpoch().longValue() * 1000L;
                long time = expiryTimeMillis - System.currentTimeMillis();
                if ("yes".equals(evaluating) && time / 300000L % 151L == 0L) {
                    this.clearFeatures();
                    throw new LicenseException("Evaluation license temporarily suspended: please try again later", 1);
                }
                return 1 + (int)(time / 86400000L);
            }
            catch (XPathException err) {
                this.clearFeatures();
                throw new LicenseException("Invalid expiry date found in license (serial " + this.getFeature("Serial") + ")", 2);
            }
        }

        public synchronized String getFeature(String name) {
            return this.features.getProperty(name);
        }

        private void clearFeatures() {
            if (this.features != null) {
                this.features.clear();
            }
        }

        public Properties getProperties() {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)this.features);
            return p;
        }
    }
}

