/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.Notation;
import java.util.ArrayList;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class SchemaFn
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        EnterpriseConfiguration config = (EnterpriseConfiguration)context.getConfiguration();
        if (arguments.length == 0) {
            return this.schemaInfo(config);
        }
        if (arguments.length == 2) {
            String kind = arguments[0].head().getStringValue();
            QNameValue name = (QNameValue)arguments[1].head();
            return this.schemaComponentInfo(config, kind, name.getStructuredQName());
        }
        throw new XPathException("Call to saxon:schema() requires either 0 or 2 arguments");
    }

    private Sequence schemaInfo(EnterpriseConfiguration config) {
        CallableDelegate schemaFunction = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Schema");
                }
                case "type definitions": {
                    ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                    for (SchemaType st : config.getSuperSchema().getAllTypes()) {
                        list.add(st.getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "attribute declarations": {
                    ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                    for (AttributeDecl decl : config.getSuperSchema().getAttributeDeclarations()) {
                        list.add(decl.getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "element declarations": {
                    ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                    for (ElementDecl decl : config.getSuperSchema().getElementDeclarations()) {
                        list.add(decl.getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "attribute group definitions": {
                    ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                    for (AttributeGroupDecl group : config.getSuperSchema().getAllAttributeGroups()) {
                        list.add(group.getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "model group definitions": {
                    ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                    for (ModelGroupDefinition group : config.getSuperSchema().getAllModelGroups()) {
                        list.add(group.getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "notation declarations": {
                    ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                    for (Notation notation : config.getSuperSchema().getAllNotations()) {
                        list.add(notation.getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "identity-constraint definitions": {
                    ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                    for (IdentityConstraint constraint : config.getSuperSchema().getIdentityConstraints()) {
                        list.add(constraint.getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)schemaFunction, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }

    private Sequence schemaComponentInfo(EnterpriseConfiguration config, String kind, StructuredQName name) throws XPathException {
        switch (kind) {
            case "attribute declaration": {
                AttributeDecl decl = (AttributeDecl)config.getAttributeDeclaration(name);
                return this.getComponentInfo(config, decl);
            }
            case "element declaration": {
                ElementDecl decl = (ElementDecl)config.getElementDeclaration(name);
                return this.getComponentInfo(config, decl);
            }
            case "attribute group definition": {
                AttributeGroupDecl decl = config.getSuperSchema().getAttributeGroup(name);
                return this.getComponentInfo(config, decl);
            }
            case "model group definition": {
                ModelGroupDefinition decl = config.getSuperSchema().getGroup(name);
                return this.getComponentInfo(config, decl);
            }
            case "notation declarations": {
                Notation decl = config.getSuperSchema().getNotation(name);
                return this.getComponentInfo(config, decl);
            }
            case "identity-constraint definitions": {
                IdentityConstraint decl = config.getSuperSchema().getIdentityConstraint(name);
                return this.getComponentInfo(config, decl);
            }
            case "type definition": {
                SchemaType type = config.getSchemaType(name);
                return this.getComponentInfo(config, type);
            }
        }
        throw new XPathException("Unknown component kind " + kind);
    }

    private Sequence getComponentInfo(EnterpriseConfiguration config, SchemaComponent component) {
        if (component == null) {
            return EmptySequence.getInstance();
        }
        return component.getComponentAsFunction();
    }
}

