/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.GroundedItemFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.NumericValue;

public class InsertBeforeStreamer
extends TransmissionAdjunct
implements FeedMaker {
    private int consumingArg = -1;

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        this.consumingArg = InsertBeforeStreamer.findConsumingArg(this.getExpression(), this.consumingArg);
        return super.getWatchMaker(forGrouping);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        this.consumingArg = InsertBeforeStreamer.findConsumingArg(this.getExpression(), this.consumingArg);
        switch (this.consumingArg) {
            case 0: {
                return new InsertBeforeFeed1((SystemFunctionCall)this.getExpression(), out, context);
            }
            case 2: {
                return new InsertBeforeFeed3((SystemFunctionCall)this.getExpression(), out, context);
            }
        }
        return this.getDefaultFeedMaker(this.consumingArg).makeItemFeed(watchManager, out, context);
    }

    private static class InsertBeforeFeed3
    extends GroundedItemFeed {
        private SequenceIterator arg0iter;

        public InsertBeforeFeed3(SystemFunctionCall exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
            int insertPosition = (int)((NumericValue)call.getArg(1).evaluateItem(this.getContext())).longValue();
            this.arg0iter = call.getArg(0).iterate(this.getContext());
            Outputter out = this.getNextOutputter();
            for (int i = 1; i < insertPosition; ++i) {
                Item it = this.arg0iter.next();
                if (it == null) {
                    this.arg0iter = null;
                    break;
                }
                out.append(it);
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            this.getNextOutputter().append(item);
        }

        @Override
        public void close() throws XPathException {
            InsertBeforeFeed3.processItems(this.arg0iter, this.getNextOutputter());
            super.close();
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            return this.getResultFeed().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.getResultFeed().endSelectedParentNode(locationId);
        }
    }

    private static class InsertBeforeFeed1
    extends GroundedItemFeed {
        int position;
        int insertPosition;

        public InsertBeforeFeed1(SystemFunctionCall exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
            this.insertPosition = (int)((NumericValue)call.getArg(1).evaluateItem(this.getContext())).longValue();
            if (this.insertPosition <= 0) {
                this.doInsertion();
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            if (++this.position == this.insertPosition) {
                this.doInsertion();
            }
            this.getNextOutputter().append(item);
        }

        private void doInsertion() throws XPathException {
            SystemFunctionCall function = (SystemFunctionCall)this.getExpression();
            SequenceIterator iter = function.getArg(2).iterate(this.getContext());
            InsertBeforeFeed1.processItems(iter, this.getNextOutputter());
        }

        @Override
        public void close() throws XPathException {
            if (++this.position <= this.insertPosition) {
                this.doInsertion();
            }
            this.getNextOutputter().close();
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (++this.position == this.insertPosition) {
                this.doInsertion();
            }
            return this.getResultFeed().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.getResultFeed().endSelectedParentNode(locationId);
        }
    }
}

