/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.wrap;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.SpanAttributeQuery;
import de.ids_mannheim.korap.query.SpanWithAttributeQuery;
import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.util.QueryException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;

public class SpanWithAttributeQueryWrapper
extends SpanQueryWrapper {
    private SpanQueryWrapper withIdQueryWrapper = null;
    private SpanQueryWrapper attrQueryWrapper = null;
    private List<SpanQueryWrapper> queryWrapperList = null;
    private boolean isSingleAttribute = false;

    public SpanWithAttributeQueryWrapper(SpanQueryWrapper attrQuery) throws QueryException {
        if (attrQuery != null) {
            this.isNull = false;
        }
        if (attrQuery.isEmpty()) {
            this.isEmpty = true;
            return;
        }
        if (attrQuery.isNegative) {
            throw new QueryException("The query requires a positive attribute.");
        }
        this.attrQueryWrapper = attrQuery;
        this.maybeUnsorted = attrQuery.maybeUnsorted();
        this.isSingleAttribute = true;
    }

    public SpanWithAttributeQueryWrapper(List<SpanQueryWrapper> attrList) throws QueryException {
        if (attrList != null) {
            this.isNull = false;
        }
        if (attrList.isEmpty()) {
            throw new QueryException("No attribute is defined.");
        }
        boolean isAllNegative = true;
        for (SpanQueryWrapper sqw : attrList) {
            if (sqw == null) {
                this.isNull = true;
                return;
            }
            if (sqw.isEmpty) {
                this.isEmpty = true;
                return;
            }
            if (sqw.isNegative) continue;
            isAllNegative = false;
        }
        if (isAllNegative) {
            throw new QueryException("No positive attribute is defined.");
        }
        this.queryWrapperList = attrList;
    }

    public SpanWithAttributeQueryWrapper(SpanQueryWrapper withIdQuery, SpanQueryWrapper attrQuery) {
        if (withIdQuery != null || attrQuery != null) {
            this.isNull = false;
        }
        if (withIdQuery.isEmpty || attrQuery.isEmpty()) {
            this.isEmpty = true;
            return;
        }
        this.attrQueryWrapper = attrQuery;
        this.withIdQueryWrapper = withIdQuery;
        this.isSingleAttribute = true;
    }

    public SpanWithAttributeQueryWrapper(SpanQueryWrapper withIdQuery, List<SpanQueryWrapper> attrList) {
        if (withIdQuery != null || attrList != null) {
            this.isNull = false;
        }
        if (withIdQuery.isEmpty) {
            this.isEmpty = true;
            return;
        }
        for (SpanQueryWrapper sqw : attrList) {
            if (sqw == null) {
                this.isNull = true;
                return;
            }
            if (!sqw.isEmpty) continue;
            this.isEmpty = true;
            return;
        }
        this.queryWrapperList = attrList;
        this.withIdQueryWrapper = withIdQuery;
    }

    @Override
    public SpanQuery toFragmentQuery() throws QueryException {
        if (this.isNull || this.isEmpty) {
            return null;
        }
        if (this.withIdQueryWrapper != null) {
            return this.createSpecificSpanWithAttributeQuery();
        }
        return this.createArbitrarySpanWithAttributeQuery();
    }

    private SpanQuery createSpecificSpanWithAttributeQuery() throws QueryException {
        SimpleSpanQuery withIdQuery = (SimpleSpanQuery)this.withIdQueryWrapper.toFragmentQuery();
        if (withIdQuery == null) {
            this.isNull = true;
            return null;
        }
        if (this.isSingleAttribute) {
            return this.createSpanWithSingleAttributeQuery(withIdQuery);
        }
        if (this.queryWrapperList.isEmpty()) {
            return withIdQuery;
        }
        return this.createSpanWithAttributeListQuery(withIdQuery);
    }

    private SpanWithAttributeQuery createSpanWithSingleAttributeQuery(SimpleSpanQuery withIdQuery) throws QueryException {
        SpanAttributeQuery attrQuery = this.createSpanAttributeQuery(this.attrQueryWrapper);
        if (attrQuery != null) {
            if (withIdQuery != null) {
                return new SpanWithAttributeQuery(withIdQuery, attrQuery, true);
            }
            return new SpanWithAttributeQuery(attrQuery, true);
        }
        this.isNull = true;
        return null;
    }

    private SpanAttributeQuery createSpanAttributeQuery(SpanQueryWrapper attrQueryWrapper) throws QueryException {
        SpanQuery sq = attrQueryWrapper.toFragmentQuery();
        if (sq != null) {
            if (sq instanceof SpanAttributeQuery) {
                return (SpanAttributeQuery)sq;
            }
            if (sq instanceof SpanTermQuery) {
                return new SpanAttributeQuery((SpanTermQuery)sq, attrQueryWrapper.isNegative, true);
            }
            throw new QueryException(713, "SpanAttributeQuery only supports SpanTermQuery.");
        }
        return null;
    }

    private SpanWithAttributeQuery createSpanWithAttributeListQuery(SimpleSpanQuery withIdQuery) throws QueryException {
        ArrayList<SpanQuery> attrQueries = new ArrayList<SpanQuery>();
        SpanAttributeQuery attrQuery = null;
        for (SpanQueryWrapper sqw : this.queryWrapperList) {
            attrQuery = this.createSpanAttributeQuery(sqw);
            if (attrQuery == null) {
                this.isNull = true;
                return null;
            }
            attrQueries.add(attrQuery);
        }
        if (withIdQuery != null) {
            return new SpanWithAttributeQuery(withIdQuery, attrQueries, true);
        }
        return new SpanWithAttributeQuery(attrQueries, true);
    }

    private SpanQuery createArbitrarySpanWithAttributeQuery() throws QueryException {
        if (this.isSingleAttribute) {
            return this.createSpanWithSingleAttributeQuery(null);
        }
        if (this.queryWrapperList.isEmpty()) {
            throw new QueryException("No attribute is defined.");
        }
        return this.createSpanWithAttributeListQuery(null);
    }
}

