/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import marmot.morph.MorphDictionary;
import marmot.morph.MorphDictionaryOptions;
import marmot.util.LineIterator;
import marmot.util.StringUtils;
import marmot.util.SymbolTable;

public class HashDictionary
extends MorphDictionary {
    private static final long serialVersionUID = 1L;
    private HashMap<String, int[]> index_map_;

    public HashDictionary() {
        this(null);
    }

    public HashDictionary(SymbolTable<String> table) {
        super(table);
    }

    @Override
    public void init(MorphDictionaryOptions options) {
        super.init(options);
        LineIterator iterator2 = new LineIterator(options.getFilename());
        HashMap<String, Set> map2 = new HashMap<String, Set>();
        int[] row_indexes = options.getIndexes();
        SymbolTable<String> table = this.getTable();
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (line.isEmpty()) continue;
            String form = (String)line.get(0);
            form = StringUtils.normalize(form, options.getNormalize());
            Set indexes = map2.computeIfAbsent(form, k -> new HashSet());
            for (int row_index : row_indexes) {
                if (row_index <= 0 || row_index >= line.size()) continue;
                String tag = (String)line.get(row_index);
                int index = table.toIndex(tag, true);
                indexes.add(index);
            }
        }
        this.index_map_ = new HashMap();
        for (Map.Entry entry : map2.entrySet()) {
            String form = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set.size() > options.getLimit()) continue;
            int[] indexes = new int[set.size()];
            int i = 0;
            Iterator iterator3 = set.iterator();
            while (iterator3.hasNext()) {
                int index = (Integer)iterator3.next();
                indexes[i++] = index;
            }
            this.index_map_.put(form, indexes);
        }
    }

    @Override
    public int[] getIndexes(String form) {
        form = StringUtils.normalize(form, this.getOptions().getNormalize());
        return this.index_map_.get(form);
    }

    public int size() {
        return this.index_map_.size();
    }
}

